package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteModelRequest(apiId: __string, modelId: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest = {
    import DeleteModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .modelId(__string.unwrap(modelId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.DeleteModelRequest.ReadOnly =
    zio.aws.apigatewayv2.model.DeleteModelRequest.wrap(buildAwsValue())
}
object DeleteModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.DeleteModelRequest =
      zio.aws.apigatewayv2.model.DeleteModelRequest(apiId, modelId)
    def apiId: __string
    def modelId: __string
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getModelId: ZIO[Any, Nothing, __string] = ZIO.succeed(modelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest
  ) extends zio.aws.apigatewayv2.model.DeleteModelRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val modelId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.modelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteModelRequest
  ): zio.aws.apigatewayv2.model.DeleteModelRequest.ReadOnly = new Wrapper(impl)
}
