package zio.aws.apigatewayv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{__double, __integer, __boolean}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RouteSettings(
    dataTraceEnabled: Option[__boolean] = None,
    detailedMetricsEnabled: Option[__boolean] = None,
    loggingLevel: Option[zio.aws.apigatewayv2.model.LoggingLevel] = None,
    throttlingBurstLimit: Option[__integer] = None,
    throttlingRateLimit: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.RouteSettings = {
    import RouteSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
      .builder()
      .optionallyWith(
        dataTraceEnabled.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.dataTraceEnabled)
      .optionallyWith(
        detailedMetricsEnabled.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.detailedMetricsEnabled)
      .optionallyWith(loggingLevel.map(value => value.unwrap))(_.loggingLevel)
      .optionallyWith(
        throttlingBurstLimit.map(value => __integer.unwrap(value): Integer)
      )(_.throttlingBurstLimit)
      .optionallyWith(
        throttlingRateLimit.map(value =>
          __double.unwrap(value): java.lang.Double
        )
      )(_.throttlingRateLimit)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.RouteSettings.ReadOnly =
    zio.aws.apigatewayv2.model.RouteSettings.wrap(buildAwsValue())
}
object RouteSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.RouteSettings =
      zio.aws.apigatewayv2.model.RouteSettings(
        dataTraceEnabled.map(value => value),
        detailedMetricsEnabled.map(value => value),
        loggingLevel.map(value => value),
        throttlingBurstLimit.map(value => value),
        throttlingRateLimit.map(value => value)
      )
    def dataTraceEnabled: Option[__boolean]
    def detailedMetricsEnabled: Option[__boolean]
    def loggingLevel: Option[zio.aws.apigatewayv2.model.LoggingLevel]
    def throttlingBurstLimit: Option[__integer]
    def throttlingRateLimit: Option[__double]
    def getDataTraceEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("dataTraceEnabled", dataTraceEnabled)
    def getDetailedMetricsEnabled: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("detailedMetricsEnabled", detailedMetricsEnabled)
    def getLoggingLevel
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.LoggingLevel] =
      AwsError.unwrapOptionField("loggingLevel", loggingLevel)
    def getThrottlingBurstLimit: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("throttlingBurstLimit", throttlingBurstLimit)
    def getThrottlingRateLimit: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("throttlingRateLimit", throttlingRateLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
  ) extends zio.aws.apigatewayv2.model.RouteSettings.ReadOnly {
    override val dataTraceEnabled: Option[__boolean] = scala
      .Option(impl.dataTraceEnabled())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val detailedMetricsEnabled: Option[__boolean] = scala
      .Option(impl.detailedMetricsEnabled())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val loggingLevel: Option[zio.aws.apigatewayv2.model.LoggingLevel] =
      scala
        .Option(impl.loggingLevel())
        .map(value => zio.aws.apigatewayv2.model.LoggingLevel.wrap(value))
    override val throttlingBurstLimit: Option[__integer] = scala
      .Option(impl.throttlingBurstLimit())
      .map(value => zio.aws.apigatewayv2.model.primitives.__integer(value))
    override val throttlingRateLimit: Option[__double] = scala
      .Option(impl.throttlingRateLimit())
      .map(value => zio.aws.apigatewayv2.model.primitives.__double(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.RouteSettings
  ): zio.aws.apigatewayv2.model.RouteSettings.ReadOnly = new Wrapper(impl)
}
