package zio.aws.apigatewayv2
import zio.aws.apigatewayv2.model.primitives.SelectionExpression.Type
import java.time.Instant
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween0And2048,
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween1And64,
  StringWithLengthBetween1And512,
  StringWithLengthBetween0And32K,
  StringWithLengthBetween1And128
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.apigatewayv2.model.primitives.Arn.Type
    object ExportedApi extends Subtype[Chunk[Byte]]
    type ExportedApi = zio.aws.apigatewayv2.model.primitives.ExportedApi.Type
    object Id extends Subtype[String]
    type Id = zio.aws.apigatewayv2.model.primitives.Id.Type
    object IntegerWithLengthBetween0And3600 extends Subtype[Int]
    type IntegerWithLengthBetween0And3600 =
      zio.aws.apigatewayv2.model.primitives.IntegerWithLengthBetween0And3600.Type
    object IntegerWithLengthBetween50And30000 extends Subtype[Int]
    type IntegerWithLengthBetween50And30000 =
      zio.aws.apigatewayv2.model.primitives.IntegerWithLengthBetween50And30000.Type
    object IntegerWithLengthBetweenMinus1And86400 extends Subtype[Int]
    type IntegerWithLengthBetweenMinus1And86400 =
      zio.aws.apigatewayv2.model.primitives.IntegerWithLengthBetweenMinus1And86400.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.apigatewayv2.model.primitives.NextToken.Type
    object SelectionExpression extends Subtype[String]
    type SelectionExpression =
      zio.aws.apigatewayv2.model.primitives.SelectionExpression.Type
    object SelectionKey extends Subtype[String]
    type SelectionKey = zio.aws.apigatewayv2.model.primitives.SelectionKey.Type
    object StringWithLengthBetween0And1024 extends Subtype[String]
    type StringWithLengthBetween0And1024 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween0And1024.Type
    object StringWithLengthBetween0And2048 extends Subtype[String]
    type StringWithLengthBetween0And2048 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween0And2048.Type
    object StringWithLengthBetween0And32K extends Subtype[String]
    type StringWithLengthBetween0And32K =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween0And32K.Type
    object StringWithLengthBetween1And1024 extends Subtype[String]
    type StringWithLengthBetween1And1024 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And1024.Type
    object StringWithLengthBetween1And128 extends Subtype[String]
    type StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And128.Type
    object StringWithLengthBetween1And1600 extends Subtype[String]
    type StringWithLengthBetween1And1600 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And1600.Type
    object StringWithLengthBetween1And256 extends Subtype[String]
    type StringWithLengthBetween1And256 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And256.Type
    object StringWithLengthBetween1And512 extends Subtype[String]
    type StringWithLengthBetween1And512 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And512.Type
    object StringWithLengthBetween1And64 extends Subtype[String]
    type StringWithLengthBetween1And64 =
      zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And64.Type
    object UriWithLengthBetween1And2048 extends Subtype[String]
    type UriWithLengthBetween1And2048 =
      zio.aws.apigatewayv2.model.primitives.UriWithLengthBetween1And2048.Type
    object __boolean extends Subtype[Boolean]
    type __boolean = zio.aws.apigatewayv2.model.primitives.__boolean.Type
    object __double extends Subtype[Double]
    type __double = zio.aws.apigatewayv2.model.primitives.__double.Type
    object __integer extends Subtype[Int]
    type __integer = zio.aws.apigatewayv2.model.primitives.__integer.Type
    object __string extends Subtype[String]
    type __string = zio.aws.apigatewayv2.model.primitives.__string.Type
    object __timestampIso8601 extends Subtype[Instant]
    type __timestampIso8601 =
      zio.aws.apigatewayv2.model.primitives.__timestampIso8601.Type
  }
  type AuthorizationScopes = List[StringWithLengthBetween1And64]
  type CorsHeaderList = List[__string]
  type CorsMethodList = List[StringWithLengthBetween1And64]
  type CorsOriginList = List[__string]
  type DomainNameConfigurations =
    List[zio.aws.apigatewayv2.model.DomainNameConfiguration]
  type IdentitySourceList = List[__string]
  type IntegrationParameters = Map[__string, StringWithLengthBetween1And512]
  type ResponseParameters =
    Map[__string, Map[__string, StringWithLengthBetween1And512]]
  type RouteModels = Map[__string, StringWithLengthBetween1And128]
  type RouteParameters =
    Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
  type RouteSettingsMap =
    Map[__string, zio.aws.apigatewayv2.model.RouteSettings]
  type SecurityGroupIdList = List[__string]
  type StageVariablesMap = Map[__string, StringWithLengthBetween0And2048]
  type SubnetIdList = List[__string]
  type Tags = Map[__string, StringWithLengthBetween1And1600]
  type TemplateMap = Map[__string, StringWithLengthBetween0And32K]
  type __listOfApi = List[zio.aws.apigatewayv2.model.Api]
  type __listOfApiMapping = List[zio.aws.apigatewayv2.model.ApiMapping]
  type __listOfAuthorizer = List[zio.aws.apigatewayv2.model.Authorizer]
  type __listOfDeployment = List[zio.aws.apigatewayv2.model.Deployment]
  type __listOfDomainName = List[zio.aws.apigatewayv2.model.DomainName]
  type __listOfIntegration = List[zio.aws.apigatewayv2.model.Integration]
  type __listOfIntegrationResponse =
    List[zio.aws.apigatewayv2.model.IntegrationResponse]
  type __listOfModel = List[zio.aws.apigatewayv2.model.Model]
  type __listOfRoute = List[zio.aws.apigatewayv2.model.Route]
  type __listOfRouteResponse = List[zio.aws.apigatewayv2.model.RouteResponse]
  type __listOfStage = List[zio.aws.apigatewayv2.model.Stage]
  type __listOfVpcLink = List[zio.aws.apigatewayv2.model.VpcLink]
  type __listOf__string = List[__string]
}
