package zio.aws.apigatewayv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{
  IntegerWithLengthBetweenMinus1And86400,
  StringWithLengthBetween1And64,
  __string,
  __boolean
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Cors(
    allowCredentials: Optional[__boolean] = Optional.Absent,
    allowHeaders: Optional[Iterable[__string]] = Optional.Absent,
    allowMethods: Optional[Iterable[StringWithLengthBetween1And64]] =
      Optional.Absent,
    allowOrigins: Optional[Iterable[__string]] = Optional.Absent,
    exposeHeaders: Optional[Iterable[__string]] = Optional.Absent,
    maxAge: Optional[IntegerWithLengthBetweenMinus1And86400] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.Cors = {
    import Cors.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.Cors
      .builder()
      .optionallyWith(allowCredentials.map(value => value: java.lang.Boolean))(
        _.allowCredentials
      )
      .optionallyWith(
        allowHeaders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowHeaders)
      .optionallyWith(
        allowMethods.map(value =>
          value.map { item =>
            StringWithLengthBetween1And64.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowMethods)
      .optionallyWith(
        allowOrigins.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowOrigins)
      .optionallyWith(
        exposeHeaders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exposeHeaders)
      .optionallyWith(
        maxAge.map(value =>
          IntegerWithLengthBetweenMinus1And86400.unwrap(value): Integer
        )
      )(_.maxAge)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.Cors.ReadOnly =
    zio.aws.apigatewayv2.model.Cors.wrap(buildAwsValue())
}
object Cors {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.apigatewayv2.model.Cors] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.Cors =
      zio.aws.apigatewayv2.model.Cors(
        allowCredentials.map(value => value),
        allowHeaders.map(value => value),
        allowMethods.map(value => value),
        allowOrigins.map(value => value),
        exposeHeaders.map(value => value),
        maxAge.map(value => value)
      )
    def allowCredentials: Optional[__boolean]
    def allowHeaders: Optional[List[__string]]
    def allowMethods: Optional[List[StringWithLengthBetween1And64]]
    def allowOrigins: Optional[List[__string]]
    def exposeHeaders: Optional[List[__string]]
    def maxAge: Optional[IntegerWithLengthBetweenMinus1And86400]
    def getAllowCredentials: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("allowCredentials", allowCredentials)
    def getAllowHeaders: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("allowHeaders", allowHeaders)
    def getAllowMethods
        : ZIO[Any, AwsError, List[StringWithLengthBetween1And64]] =
      AwsError.unwrapOptionField("allowMethods", allowMethods)
    def getAllowOrigins: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("allowOrigins", allowOrigins)
    def getExposeHeaders: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("exposeHeaders", exposeHeaders)
    def getMaxAge: ZIO[Any, AwsError, IntegerWithLengthBetweenMinus1And86400] =
      AwsError.unwrapOptionField("maxAge", maxAge)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Cors
  ) extends zio.aws.apigatewayv2.model.Cors.ReadOnly {
    override val allowCredentials: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowCredentials())
      .map(value => value: __boolean)
    override val allowHeaders: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowHeaders())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val allowMethods: Optional[List[StringWithLengthBetween1And64]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMethods())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And64(item)
          }.toList
        )
    override val allowOrigins: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowOrigins())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val exposeHeaders: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.exposeHeaders())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val maxAge: Optional[IntegerWithLengthBetweenMinus1And86400] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAge())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .IntegerWithLengthBetweenMinus1And86400(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Cors
  ): zio.aws.apigatewayv2.model.Cors.ReadOnly = new Wrapper(impl)
}
