package zio.aws.apigatewayv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  StringWithLengthBetween0And1024,
  __timestampIso8601,
  Id
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Deployment(
    autoDeployed: Optional[__boolean] = Optional.Absent,
    createdDate: Optional[__timestampIso8601] = Optional.Absent,
    deploymentId: Optional[Id] = Optional.Absent,
    deploymentStatus: Optional[zio.aws.apigatewayv2.model.DeploymentStatus] =
      Optional.Absent,
    deploymentStatusMessage: Optional[__string] = Optional.Absent,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.Deployment = {
    import Deployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.Deployment
      .builder()
      .optionallyWith(autoDeployed.map(value => value: java.lang.Boolean))(
        _.autoDeployed
      )
      .optionallyWith(createdDate.map(value => value: Instant))(_.createdDate)
      .optionallyWith(
        deploymentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(deploymentStatus.map(value => value.unwrap))(
        _.deploymentStatus
      )
      .optionallyWith(
        deploymentStatusMessage.map(value => value: java.lang.String)
      )(_.deploymentStatusMessage)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.Deployment.ReadOnly =
    zio.aws.apigatewayv2.model.Deployment.wrap(buildAwsValue())
}
object Deployment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.Deployment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.Deployment =
      zio.aws.apigatewayv2.model.Deployment(
        autoDeployed.map(value => value),
        createdDate.map(value => value),
        deploymentId.map(value => value),
        deploymentStatus.map(value => value),
        deploymentStatusMessage.map(value => value),
        description.map(value => value)
      )
    def autoDeployed: Optional[__boolean]
    def createdDate: Optional[__timestampIso8601]
    def deploymentId: Optional[Id]
    def deploymentStatus: Optional[zio.aws.apigatewayv2.model.DeploymentStatus]
    def deploymentStatusMessage: Optional[__string]
    def description: Optional[StringWithLengthBetween0And1024]
    def getAutoDeployed: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("autoDeployed", autoDeployed)
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDeploymentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDeploymentStatus
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.DeploymentStatus] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Deployment
  ) extends zio.aws.apigatewayv2.model.Deployment.ReadOnly {
    override val autoDeployed: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoDeployed())
      .map(value => value: __boolean)
    override val createdDate: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdDate())
        .map(value => value: __timestampIso8601)
    override val deploymentId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val deploymentStatus
        : Optional[zio.aws.apigatewayv2.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatus())
        .map(value => zio.aws.apigatewayv2.model.DeploymentStatus.wrap(value))
    override val deploymentStatusMessage: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => value: __string)
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.Deployment
  ): zio.aws.apigatewayv2.model.Deployment.ReadOnly = new Wrapper(impl)
}
