package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  SelectionKey,
  SelectionExpression,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRouteResponseResponse(
    modelSelectionExpression: Optional[SelectionExpression] = Optional.Absent,
    responseModels: Optional[Map[__string, StringWithLengthBetween1And128]] =
      Optional.Absent,
    responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
    ] = Optional.Absent,
    routeResponseId: Optional[Id] = Optional.Absent,
    routeResponseKey: Optional[SelectionKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse = {
    import GetRouteResponseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse
      .builder()
      .optionallyWith(
        modelSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.modelSelectionExpression)
      .optionallyWith(
        responseModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And128.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseModels)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        routeResponseId.map(value => Id.unwrap(value): java.lang.String)
      )(_.routeResponseId)
      .optionallyWith(
        routeResponseKey.map(value =>
          SelectionKey.unwrap(value): java.lang.String
        )
      )(_.routeResponseKey)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetRouteResponseResponse.wrap(buildAwsValue())
}
object GetRouteResponseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetRouteResponseResponse =
      zio.aws.apigatewayv2.model.GetRouteResponseResponse(
        modelSelectionExpression.map(value => value),
        responseModels.map(value => value),
        responseParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        routeResponseId.map(value => value),
        routeResponseKey.map(value => value)
      )
    def modelSelectionExpression: Optional[SelectionExpression]
    def responseModels: Optional[Map[__string, StringWithLengthBetween1And128]]
    def responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ]
    def routeResponseId: Optional[Id]
    def routeResponseKey: Optional[SelectionKey]
    def getModelSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "modelSelectionExpression",
        modelSelectionExpression
      )
    def getResponseModels
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And128]] =
      AwsError.unwrapOptionField("responseModels", responseModels)
    def getResponseParameters: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly
    ]] = AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getRouteResponseId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("routeResponseId", routeResponseId)
    def getRouteResponseKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("routeResponseKey", routeResponseKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse
  ) extends zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly {
    override val modelSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val responseModels
        : Optional[Map[__string, StringWithLengthBetween1And128]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseModels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And128(value)
            })
            .toMap
        )
    override val responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.ParameterConstraints
              .wrap(value)
          })
          .toMap
      )
    override val routeResponseId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.routeResponseId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val routeResponseKey: Optional[SelectionKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeResponseKey())
        .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponseResponse
  ): zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly = new Wrapper(
    impl
  )
}
