package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentStatus {
  def unwrap
      : software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus
}
object DeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus
  ): zio.aws.apigatewayv2.model.DeploymentStatus = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.DEPLOYED =>
      val r = DEPLOYED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus =
      software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.apigatewayv2.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus =
      software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.PENDING
  }
  case object FAILED extends zio.aws.apigatewayv2.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus =
      software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.FAILED
  }
  case object DEPLOYED extends zio.aws.apigatewayv2.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus =
      software.amazon.awssdk.services.apigatewayv2.model.DeploymentStatus.DEPLOYED
  }
}
