package zio.aws.apigatewayv2
import zio.aws.apigatewayv2.model.UpdateAuthorizerResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.apigatewayv2.model.{
  ExportApiRequest,
  DeleteRouteResponse,
  UpdateIntegrationRequest,
  UpdateIntegrationResponseResponse,
  GetApiResponse,
  DeleteDeploymentRequest,
  DeleteRouteRequest,
  DeleteCorsConfigurationRequest,
  GetIntegrationsResponse,
  GetDomainNamesRequest,
  GetModelsResponse,
  ResetAuthorizersCacheResponse,
  DeleteAuthorizerResponse,
  CreateIntegrationRequest,
  CreateStageRequest,
  UpdateRouteResponseRequest,
  Stage,
  GetModelResponse,
  CreateStageResponse,
  UpdateApiMappingRequest,
  Api,
  CreateVpcLinkRequest,
  UpdateIntegrationResponseRequest,
  GetTagsResponse,
  DeleteRouteResponseResponse,
  CreateApiRequest,
  GetIntegrationResponsesRequest,
  GetApiMappingResponse,
  UpdateDeploymentRequest,
  GetIntegrationRequest,
  GetDeploymentsResponse,
  DeleteVpcLinkRequest,
  DeleteApiMappingRequest,
  UpdateVpcLinkRequest,
  GetApisRequest,
  DeleteStageRequest,
  DeleteIntegrationResponse,
  ReimportApiRequest,
  GetAuthorizerRequest,
  DeleteCorsConfigurationResponse,
  CreateAuthorizerRequest,
  CreateIntegrationResponse,
  GetModelTemplateResponse,
  DeleteRouteSettingsResponse,
  UpdateApiResponse,
  ImportApiResponse,
  GetStagesRequest,
  CreateIntegrationResponseRequest,
  GetDeploymentsRequest,
  CreateRouteResponse,
  UpdateStageResponse,
  DeleteAccessLogSettingsRequest,
  ImportApiRequest,
  CreateRouteRequest,
  CreateModelRequest,
  GetApiRequest,
  DeleteApiRequest,
  DeleteIntegrationRequest,
  DomainName,
  DeleteRouteResponseRequest,
  CreateApiMappingRequest,
  DeleteApiMappingResponse,
  UpdateIntegrationResponse,
  CreateDomainNameResponse,
  DeleteRouteSettingsRequest,
  GetIntegrationResponseRequest,
  GetRoutesRequest,
  GetApiMappingRequest,
  ResetAuthorizersCacheRequest,
  IntegrationResponse,
  CreateVpcLinkResponse,
  CreateDeploymentResponse,
  DeleteAuthorizerRequest,
  UntagResourceResponse,
  Authorizer,
  DeleteModelResponse,
  UpdateApiRequest,
  GetVpcLinksRequest,
  GetApiMappingsResponse,
  GetRouteRequest,
  Model,
  GetAuthorizersResponse,
  UpdateDomainNameResponse,
  Deployment,
  GetModelTemplateRequest,
  DeleteDomainNameRequest,
  GetIntegrationResponsesResponse,
  DeleteDomainNameResponse,
  UpdateRouteRequest,
  UpdateAuthorizerResponse,
  GetStagesResponse,
  GetIntegrationsRequest,
  UpdateDomainNameRequest,
  CreateDomainNameRequest,
  ReimportApiResponse,
  GetVpcLinkRequest,
  GetRoutesResponse,
  GetDomainNamesResponse,
  UpdateModelResponse,
  UpdateDeploymentResponse,
  CreateRouteResponseRequest,
  GetApiMappingsRequest,
  CreateIntegrationResponseResponse,
  DeleteRouteRequestParameterResponse,
  Route,
  DeleteApiResponse,
  CreateAuthorizerResponse,
  ApiMapping,
  CreateModelResponse,
  UntagResourceRequest,
  GetStageRequest,
  DeleteVpcLinkResponse,
  UpdateStageRequest,
  GetIntegrationResponse,
  GetVpcLinkResponse,
  GetAuthorizerResponse,
  GetTagsRequest,
  DeleteAccessLogSettingsResponse,
  CreateApiResponse,
  GetStageResponse,
  CreateRouteResponseResponse,
  ExportApiResponse,
  DeleteIntegrationResponseRequest,
  GetDomainNameResponse,
  VpcLink,
  RouteResponse,
  CreateDeploymentRequest,
  UpdateModelRequest,
  GetModelRequest,
  GetDeploymentRequest,
  UpdateRouteResponseResponse,
  GetIntegrationResponseResponse,
  GetModelsRequest,
  DeleteModelRequest,
  GetRouteResponsesResponse,
  DeleteRouteRequestParameterRequest,
  DeleteIntegrationResponseResponse,
  GetRouteResponseResponse,
  GetApisResponse,
  GetRouteResponse,
  GetAuthorizersRequest,
  CreateApiMappingResponse,
  GetDomainNameRequest,
  TagResourceResponse,
  GetRouteResponsesRequest,
  GetVpcLinksResponse,
  GetRouteResponseRequest,
  UpdateApiMappingResponse,
  DeleteDeploymentResponse,
  GetDeploymentResponse,
  UpdateVpcLinkResponse,
  TagResourceRequest,
  UpdateAuthorizerRequest,
  Integration,
  DeleteStageResponse,
  UpdateRouteResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.apigatewayv2.{
  ApiGatewayV2AsyncClientBuilder,
  ApiGatewayV2AsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait ApiGatewayV2 extends AspectSupport[ApiGatewayV2] {
  val api: ApiGatewayV2AsyncClient
  def updateRouteResponse(
      request: zio.aws.apigatewayv2.model.UpdateRouteResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigatewayv2.model.UpdateRouteResponseResponse.ReadOnly
  ]
  def resetAuthorizersCache(
      request: zio.aws.apigatewayv2.model.ResetAuthorizersCacheRequest
  ): IO[AwsError, Unit]
  def updateStage(
      request: zio.aws.apigatewayv2.model.UpdateStageRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateStageResponse.ReadOnly]
  def getVpcLinks(
      request: zio.aws.apigatewayv2.model.GetVpcLinksRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.VpcLink.ReadOnly]
  def getVpcLinksPaginated(
      request: zio.aws.apigatewayv2.model.GetVpcLinksRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly]
  def createRoute(
      request: zio.aws.apigatewayv2.model.CreateRouteRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateRouteResponse.ReadOnly]
  def deleteRoute(
      request: zio.aws.apigatewayv2.model.DeleteRouteRequest
  ): IO[AwsError, Unit]
  def importApi(
      request: zio.aws.apigatewayv2.model.ImportApiRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.ImportApiResponse.ReadOnly]
  def getRouteResponses(
      request: zio.aws.apigatewayv2.model.GetRouteResponsesRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.RouteResponse.ReadOnly]
  def getRouteResponsesPaginated(
      request: zio.aws.apigatewayv2.model.GetRouteResponsesRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly]
  def getDomainNames(
      request: zio.aws.apigatewayv2.model.GetDomainNamesRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.DomainName.ReadOnly]
  def getDomainNamesPaginated(
      request: zio.aws.apigatewayv2.model.GetDomainNamesRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetDomainNamesResponse.ReadOnly]
  def updateRoute(
      request: zio.aws.apigatewayv2.model.UpdateRouteRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly]
  def getRouteResponse(
      request: zio.aws.apigatewayv2.model.GetRouteResponseRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly]
  def createModel(
      request: zio.aws.apigatewayv2.model.CreateModelRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly]
  def exportApi(
      request: zio.aws.apigatewayv2.model.ExportApiRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly]
  def updateModel(
      request: zio.aws.apigatewayv2.model.UpdateModelRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateModelResponse.ReadOnly]
  def deleteAccessLogSettings(
      request: zio.aws.apigatewayv2.model.DeleteAccessLogSettingsRequest
  ): IO[AwsError, Unit]
  def deleteVpcLink(
      request: zio.aws.apigatewayv2.model.DeleteVpcLinkRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.DeleteVpcLinkResponse.ReadOnly]
  def getVpcLink(
      request: zio.aws.apigatewayv2.model.GetVpcLinkRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly]
  def deleteApi(
      request: zio.aws.apigatewayv2.model.DeleteApiRequest
  ): IO[AwsError, Unit]
  def getDeployment(
      request: zio.aws.apigatewayv2.model.GetDeploymentRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly]
  def deleteDeployment(
      request: zio.aws.apigatewayv2.model.DeleteDeploymentRequest
  ): IO[AwsError, Unit]
  def deleteCorsConfiguration(
      request: zio.aws.apigatewayv2.model.DeleteCorsConfigurationRequest
  ): IO[AwsError, Unit]
  def getStage(
      request: zio.aws.apigatewayv2.model.GetStageRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly]
  def deleteIntegration(
      request: zio.aws.apigatewayv2.model.DeleteIntegrationRequest
  ): IO[AwsError, Unit]
  def updateDeployment(
      request: zio.aws.apigatewayv2.model.UpdateDeploymentRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateDeploymentResponse.ReadOnly]
  def getIntegrationResponse(
      request: zio.aws.apigatewayv2.model.GetIntegrationResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly
  ]
  def getApiMappings(
      request: zio.aws.apigatewayv2.model.GetApiMappingsRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.ApiMapping.ReadOnly]
  def getApiMappingsPaginated(
      request: zio.aws.apigatewayv2.model.GetApiMappingsRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly]
  def updateVpcLink(
      request: zio.aws.apigatewayv2.model.UpdateVpcLinkRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateVpcLinkResponse.ReadOnly]
  def getModel(
      request: zio.aws.apigatewayv2.model.GetModelRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly]
  def updateAuthorizer(
      request: zio.aws.apigatewayv2.model.UpdateAuthorizerRequest
  ): IO[AwsError, ReadOnly]
  def deleteRouteRequestParameter(
      request: zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest
  ): IO[AwsError, Unit]
  def deleteStage(
      request: zio.aws.apigatewayv2.model.DeleteStageRequest
  ): IO[AwsError, Unit]
  def deleteApiMapping(
      request: zio.aws.apigatewayv2.model.DeleteApiMappingRequest
  ): IO[AwsError, Unit]
  def createApiMapping(
      request: zio.aws.apigatewayv2.model.CreateApiMappingRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly]
  def deleteModel(
      request: zio.aws.apigatewayv2.model.DeleteModelRequest
  ): IO[AwsError, Unit]
  def createDomainName(
      request: zio.aws.apigatewayv2.model.CreateDomainNameRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly]
  def reimportApi(
      request: zio.aws.apigatewayv2.model.ReimportApiRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.ReimportApiResponse.ReadOnly]
  def getApi(
      request: zio.aws.apigatewayv2.model.GetApiRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetApiResponse.ReadOnly]
  def deleteRouteSettings(
      request: zio.aws.apigatewayv2.model.DeleteRouteSettingsRequest
  ): IO[AwsError, Unit]
  def createApi(
      request: zio.aws.apigatewayv2.model.CreateApiRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly]
  def createVpcLink(
      request: zio.aws.apigatewayv2.model.CreateVpcLinkRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateVpcLinkResponse.ReadOnly]
  def updateApi(
      request: zio.aws.apigatewayv2.model.UpdateApiRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateApiResponse.ReadOnly]
  def untagResource(
      request: zio.aws.apigatewayv2.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def getAuthorizers(
      request: zio.aws.apigatewayv2.model.GetAuthorizersRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Authorizer.ReadOnly]
  def getAuthorizersPaginated(
      request: zio.aws.apigatewayv2.model.GetAuthorizersRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetAuthorizersResponse.ReadOnly]
  def updateIntegrationResponse(
      request: zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly
  ]
  def createDeployment(
      request: zio.aws.apigatewayv2.model.CreateDeploymentRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateDeploymentResponse.ReadOnly]
  def getRoute(
      request: zio.aws.apigatewayv2.model.GetRouteRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetRouteResponse.ReadOnly]
  def getModelTemplate(
      request: zio.aws.apigatewayv2.model.GetModelTemplateRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetModelTemplateResponse.ReadOnly]
  def createStage(
      request: zio.aws.apigatewayv2.model.CreateStageRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateStageResponse.ReadOnly]
  def getApiMapping(
      request: zio.aws.apigatewayv2.model.GetApiMappingRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetApiMappingResponse.ReadOnly]
  def createAuthorizer(
      request: zio.aws.apigatewayv2.model.CreateAuthorizerRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly]
  def createRouteResponse(
      request: zio.aws.apigatewayv2.model.CreateRouteResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigatewayv2.model.CreateRouteResponseResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.apigatewayv2.model.TagResourceRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.TagResourceResponse.ReadOnly]
  def getIntegration(
      request: zio.aws.apigatewayv2.model.GetIntegrationRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly]
  def createIntegrationResponse(
      request: zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest
  ): IO[
    AwsError,
    zio.aws.apigatewayv2.model.CreateIntegrationResponseResponse.ReadOnly
  ]
  def getDeployments(
      request: zio.aws.apigatewayv2.model.GetDeploymentsRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Deployment.ReadOnly]
  def getDeploymentsPaginated(
      request: zio.aws.apigatewayv2.model.GetDeploymentsRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly]
  def updateApiMapping(
      request: zio.aws.apigatewayv2.model.UpdateApiMappingRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly]
  def deleteAuthorizer(
      request: zio.aws.apigatewayv2.model.DeleteAuthorizerRequest
  ): IO[AwsError, Unit]
  def deleteIntegrationResponse(
      request: zio.aws.apigatewayv2.model.DeleteIntegrationResponseRequest
  ): IO[AwsError, Unit]
  def getIntegrationResponses(
      request: zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.apigatewayv2.model.IntegrationResponse.ReadOnly
  ]
  def getIntegrationResponsesPaginated(
      request: zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest
  ): IO[
    AwsError,
    zio.aws.apigatewayv2.model.GetIntegrationResponsesResponse.ReadOnly
  ]
  def updateIntegration(
      request: zio.aws.apigatewayv2.model.UpdateIntegrationRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateIntegrationResponse.ReadOnly]
  def createIntegration(
      request: zio.aws.apigatewayv2.model.CreateIntegrationRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.CreateIntegrationResponse.ReadOnly]
  def getModels(
      request: zio.aws.apigatewayv2.model.GetModelsRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Model.ReadOnly]
  def getModelsPaginated(
      request: zio.aws.apigatewayv2.model.GetModelsRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetModelsResponse.ReadOnly]
  def getStages(
      request: zio.aws.apigatewayv2.model.GetStagesRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Stage.ReadOnly]
  def getStagesPaginated(
      request: zio.aws.apigatewayv2.model.GetStagesRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetStagesResponse.ReadOnly]
  def getDomainName(
      request: zio.aws.apigatewayv2.model.GetDomainNameRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetDomainNameResponse.ReadOnly]
  def getIntegrations(
      request: zio.aws.apigatewayv2.model.GetIntegrationsRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Integration.ReadOnly]
  def getIntegrationsPaginated(
      request: zio.aws.apigatewayv2.model.GetIntegrationsRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetIntegrationsResponse.ReadOnly]
  def getRoutes(
      request: zio.aws.apigatewayv2.model.GetRoutesRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Route.ReadOnly]
  def getRoutesPaginated(
      request: zio.aws.apigatewayv2.model.GetRoutesRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetRoutesResponse.ReadOnly]
  def getAuthorizer(
      request: zio.aws.apigatewayv2.model.GetAuthorizerRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetAuthorizerResponse.ReadOnly]
  def deleteDomainName(
      request: zio.aws.apigatewayv2.model.DeleteDomainNameRequest
  ): IO[AwsError, Unit]
  def getApis(
      request: zio.aws.apigatewayv2.model.GetApisRequest
  ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Api.ReadOnly]
  def getApisPaginated(
      request: zio.aws.apigatewayv2.model.GetApisRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetApisResponse.ReadOnly]
  def deleteRouteResponse(
      request: zio.aws.apigatewayv2.model.DeleteRouteResponseRequest
  ): IO[AwsError, Unit]
  def updateDomainName(
      request: zio.aws.apigatewayv2.model.UpdateDomainNameRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly]
  def getTags(
      request: zio.aws.apigatewayv2.model.GetTagsRequest
  ): IO[AwsError, zio.aws.apigatewayv2.model.GetTagsResponse.ReadOnly]
}
object ApiGatewayV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ApiGatewayV2] = customized(
    identity
  )
  def customized(
      customization: ApiGatewayV2AsyncClientBuilder => ApiGatewayV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ApiGatewayV2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ApiGatewayV2AsyncClientBuilder => ApiGatewayV2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ApiGatewayV2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ApiGatewayV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ApiGatewayV2AsyncClient, ApiGatewayV2AsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ApiGatewayV2AsyncClient,
      ApiGatewayV2AsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ApiGatewayV2Impl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ApiGatewayV2Impl[R](
      override val api: ApiGatewayV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ApiGatewayV2
      with AwsServiceBase[R] {
    override val serviceName: String = "ApiGatewayV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ApiGatewayV2Impl[R1] = new ApiGatewayV2Impl(api, newAspect, r)
    def updateRouteResponse(
        request: zio.aws.apigatewayv2.model.UpdateRouteResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.UpdateRouteResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRouteResponseRequest,
      UpdateRouteResponseResponse
    ]("updateRouteResponse", api.updateRouteResponse)(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.UpdateRouteResponseResponse.wrap)
      .provideEnvironment(r)
    def resetAuthorizersCache(
        request: zio.aws.apigatewayv2.model.ResetAuthorizersCacheRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ResetAuthorizersCacheRequest,
      ResetAuthorizersCacheResponse
    ]("resetAuthorizersCache", api.resetAuthorizersCache)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateStage(
        request: zio.aws.apigatewayv2.model.UpdateStageRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateStageResponse.ReadOnly] =
      asyncRequestResponse[UpdateStageRequest, UpdateStageResponse](
        "updateStage",
        api.updateStage
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.UpdateStageResponse.wrap)
        .provideEnvironment(r)
    def getVpcLinks(
        request: zio.aws.apigatewayv2.model.GetVpcLinksRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.VpcLink.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetVpcLinksRequest,
        GetVpcLinksResponse,
        VpcLink
      ](
        "getVpcLinks",
        api.getVpcLinks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.VpcLink.wrap(item))
        .provideEnvironment(r)
    def getVpcLinksPaginated(
        request: zio.aws.apigatewayv2.model.GetVpcLinksRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly] =
      asyncRequestResponse[GetVpcLinksRequest, GetVpcLinksResponse](
        "getVpcLinks",
        api.getVpcLinks
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetVpcLinksResponse.wrap)
        .provideEnvironment(r)
    def createRoute(
        request: zio.aws.apigatewayv2.model.CreateRouteRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.CreateRouteResponse.ReadOnly] =
      asyncRequestResponse[CreateRouteRequest, CreateRouteResponse](
        "createRoute",
        api.createRoute
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.CreateRouteResponse.wrap)
        .provideEnvironment(r)
    def deleteRoute(
        request: zio.aws.apigatewayv2.model.DeleteRouteRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRouteRequest, DeleteRouteResponse](
        "deleteRoute",
        api.deleteRoute
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def importApi(
        request: zio.aws.apigatewayv2.model.ImportApiRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.ImportApiResponse.ReadOnly] =
      asyncRequestResponse[ImportApiRequest, ImportApiResponse](
        "importApi",
        api.importApi
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.ImportApiResponse.wrap)
        .provideEnvironment(r)
    def getRouteResponses(
        request: zio.aws.apigatewayv2.model.GetRouteResponsesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.RouteResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetRouteResponsesRequest,
      GetRouteResponsesResponse,
      RouteResponse
    ](
      "getRouteResponses",
      api.getRouteResponses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.apigatewayv2.model.RouteResponse.wrap(item))
      .provideEnvironment(r)
    def getRouteResponsesPaginated(
        request: zio.aws.apigatewayv2.model.GetRouteResponsesRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly
    ] =
      asyncRequestResponse[GetRouteResponsesRequest, GetRouteResponsesResponse](
        "getRouteResponses",
        api.getRouteResponses
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetRouteResponsesResponse.wrap)
        .provideEnvironment(r)
    def getDomainNames(
        request: zio.aws.apigatewayv2.model.GetDomainNamesRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.DomainName.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetDomainNamesRequest,
        GetDomainNamesResponse,
        DomainName
      ](
        "getDomainNames",
        api.getDomainNames,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.DomainName.wrap(item))
        .provideEnvironment(r)
    def getDomainNamesPaginated(
        request: zio.aws.apigatewayv2.model.GetDomainNamesRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetDomainNamesResponse.ReadOnly
    ] = asyncRequestResponse[GetDomainNamesRequest, GetDomainNamesResponse](
      "getDomainNames",
      api.getDomainNames
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetDomainNamesResponse.wrap)
      .provideEnvironment(r)
    def updateRoute(
        request: zio.aws.apigatewayv2.model.UpdateRouteRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly] =
      asyncRequestResponse[UpdateRouteRequest, UpdateRouteResponse](
        "updateRoute",
        api.updateRoute
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.UpdateRouteResponse.wrap)
        .provideEnvironment(r)
    def getRouteResponse(
        request: zio.aws.apigatewayv2.model.GetRouteResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly
    ] = asyncRequestResponse[GetRouteResponseRequest, GetRouteResponseResponse](
      "getRouteResponse",
      api.getRouteResponse
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetRouteResponseResponse.wrap)
      .provideEnvironment(r)
    def createModel(
        request: zio.aws.apigatewayv2.model.CreateModelRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly] =
      asyncRequestResponse[CreateModelRequest, CreateModelResponse](
        "createModel",
        api.createModel
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.CreateModelResponse.wrap)
        .provideEnvironment(r)
    def exportApi(
        request: zio.aws.apigatewayv2.model.ExportApiRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly] =
      asyncRequestResponse[ExportApiRequest, ExportApiResponse](
        "exportApi",
        api.exportApi
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.ExportApiResponse.wrap)
        .provideEnvironment(r)
    def updateModel(
        request: zio.aws.apigatewayv2.model.UpdateModelRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateModelResponse.ReadOnly] =
      asyncRequestResponse[UpdateModelRequest, UpdateModelResponse](
        "updateModel",
        api.updateModel
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.UpdateModelResponse.wrap)
        .provideEnvironment(r)
    def deleteAccessLogSettings(
        request: zio.aws.apigatewayv2.model.DeleteAccessLogSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteAccessLogSettingsRequest,
      DeleteAccessLogSettingsResponse
    ]("deleteAccessLogSettings", api.deleteAccessLogSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteVpcLink(
        request: zio.aws.apigatewayv2.model.DeleteVpcLinkRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.DeleteVpcLinkResponse.ReadOnly] =
      asyncRequestResponse[DeleteVpcLinkRequest, DeleteVpcLinkResponse](
        "deleteVpcLink",
        api.deleteVpcLink
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.DeleteVpcLinkResponse.wrap)
        .provideEnvironment(r)
    def getVpcLink(
        request: zio.aws.apigatewayv2.model.GetVpcLinkRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly] =
      asyncRequestResponse[GetVpcLinkRequest, GetVpcLinkResponse](
        "getVpcLink",
        api.getVpcLink
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetVpcLinkResponse.wrap)
        .provideEnvironment(r)
    def deleteApi(
        request: zio.aws.apigatewayv2.model.DeleteApiRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteApiRequest, DeleteApiResponse](
        "deleteApi",
        api.deleteApi
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getDeployment(
        request: zio.aws.apigatewayv2.model.GetDeploymentRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly] =
      asyncRequestResponse[GetDeploymentRequest, GetDeploymentResponse](
        "getDeployment",
        api.getDeployment
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetDeploymentResponse.wrap)
        .provideEnvironment(r)
    def deleteDeployment(
        request: zio.aws.apigatewayv2.model.DeleteDeploymentRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDeploymentRequest, DeleteDeploymentResponse](
        "deleteDeployment",
        api.deleteDeployment
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteCorsConfiguration(
        request: zio.aws.apigatewayv2.model.DeleteCorsConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteCorsConfigurationRequest,
      DeleteCorsConfigurationResponse
    ]("deleteCorsConfiguration", api.deleteCorsConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getStage(
        request: zio.aws.apigatewayv2.model.GetStageRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly] =
      asyncRequestResponse[GetStageRequest, GetStageResponse](
        "getStage",
        api.getStage
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetStageResponse.wrap)
        .provideEnvironment(r)
    def deleteIntegration(
        request: zio.aws.apigatewayv2.model.DeleteIntegrationRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteIntegrationRequest, DeleteIntegrationResponse](
        "deleteIntegration",
        api.deleteIntegration
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateDeployment(
        request: zio.aws.apigatewayv2.model.UpdateDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.UpdateDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDeploymentRequest, UpdateDeploymentResponse](
      "updateDeployment",
      api.updateDeployment
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.UpdateDeploymentResponse.wrap)
      .provideEnvironment(r)
    def getIntegrationResponse(
        request: zio.aws.apigatewayv2.model.GetIntegrationResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      GetIntegrationResponseRequest,
      GetIntegrationResponseResponse
    ]("getIntegrationResponse", api.getIntegrationResponse)(
      request.buildAwsValue()
    ).map(zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.wrap)
      .provideEnvironment(r)
    def getApiMappings(
        request: zio.aws.apigatewayv2.model.GetApiMappingsRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.ApiMapping.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetApiMappingsRequest,
        GetApiMappingsResponse,
        ApiMapping
      ](
        "getApiMappings",
        api.getApiMappings,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.ApiMapping.wrap(item))
        .provideEnvironment(r)
    def getApiMappingsPaginated(
        request: zio.aws.apigatewayv2.model.GetApiMappingsRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly
    ] = asyncRequestResponse[GetApiMappingsRequest, GetApiMappingsResponse](
      "getApiMappings",
      api.getApiMappings
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetApiMappingsResponse.wrap)
      .provideEnvironment(r)
    def updateVpcLink(
        request: zio.aws.apigatewayv2.model.UpdateVpcLinkRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateVpcLinkResponse.ReadOnly] =
      asyncRequestResponse[UpdateVpcLinkRequest, UpdateVpcLinkResponse](
        "updateVpcLink",
        api.updateVpcLink
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.UpdateVpcLinkResponse.wrap)
        .provideEnvironment(r)
    def getModel(
        request: zio.aws.apigatewayv2.model.GetModelRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly] =
      asyncRequestResponse[GetModelRequest, GetModelResponse](
        "getModel",
        api.getModel
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetModelResponse.wrap)
        .provideEnvironment(r)
    def updateAuthorizer(
        request: zio.aws.apigatewayv2.model.UpdateAuthorizerRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[UpdateAuthorizerRequest, UpdateAuthorizerResponse](
        "updateAuthorizer",
        api.updateAuthorizer
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.UpdateAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def deleteRouteRequestParameter(
        request: zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteRouteRequestParameterRequest,
      DeleteRouteRequestParameterResponse
    ]("deleteRouteRequestParameter", api.deleteRouteRequestParameter)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteStage(
        request: zio.aws.apigatewayv2.model.DeleteStageRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteStageRequest, DeleteStageResponse](
        "deleteStage",
        api.deleteStage
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteApiMapping(
        request: zio.aws.apigatewayv2.model.DeleteApiMappingRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteApiMappingRequest, DeleteApiMappingResponse](
        "deleteApiMapping",
        api.deleteApiMapping
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createApiMapping(
        request: zio.aws.apigatewayv2.model.CreateApiMappingRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly
    ] = asyncRequestResponse[CreateApiMappingRequest, CreateApiMappingResponse](
      "createApiMapping",
      api.createApiMapping
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.CreateApiMappingResponse.wrap)
      .provideEnvironment(r)
    def deleteModel(
        request: zio.aws.apigatewayv2.model.DeleteModelRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteModelRequest, DeleteModelResponse](
        "deleteModel",
        api.deleteModel
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createDomainName(
        request: zio.aws.apigatewayv2.model.CreateDomainNameRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly
    ] = asyncRequestResponse[CreateDomainNameRequest, CreateDomainNameResponse](
      "createDomainName",
      api.createDomainName
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.CreateDomainNameResponse.wrap)
      .provideEnvironment(r)
    def reimportApi(
        request: zio.aws.apigatewayv2.model.ReimportApiRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.ReimportApiResponse.ReadOnly] =
      asyncRequestResponse[ReimportApiRequest, ReimportApiResponse](
        "reimportApi",
        api.reimportApi
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.ReimportApiResponse.wrap)
        .provideEnvironment(r)
    def getApi(
        request: zio.aws.apigatewayv2.model.GetApiRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetApiResponse.ReadOnly] =
      asyncRequestResponse[GetApiRequest, GetApiResponse]("getApi", api.getApi)(
        request.buildAwsValue()
      ).map(zio.aws.apigatewayv2.model.GetApiResponse.wrap)
        .provideEnvironment(r)
    def deleteRouteSettings(
        request: zio.aws.apigatewayv2.model.DeleteRouteSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteRouteSettingsRequest,
      DeleteRouteSettingsResponse
    ]("deleteRouteSettings", api.deleteRouteSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createApi(
        request: zio.aws.apigatewayv2.model.CreateApiRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly] =
      asyncRequestResponse[CreateApiRequest, CreateApiResponse](
        "createApi",
        api.createApi
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.CreateApiResponse.wrap)
        .provideEnvironment(r)
    def createVpcLink(
        request: zio.aws.apigatewayv2.model.CreateVpcLinkRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.CreateVpcLinkResponse.ReadOnly] =
      asyncRequestResponse[CreateVpcLinkRequest, CreateVpcLinkResponse](
        "createVpcLink",
        api.createVpcLink
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.CreateVpcLinkResponse.wrap)
        .provideEnvironment(r)
    def updateApi(
        request: zio.aws.apigatewayv2.model.UpdateApiRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.UpdateApiResponse.ReadOnly] =
      asyncRequestResponse[UpdateApiRequest, UpdateApiResponse](
        "updateApi",
        api.updateApi
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.UpdateApiResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.apigatewayv2.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getAuthorizers(
        request: zio.aws.apigatewayv2.model.GetAuthorizersRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Authorizer.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetAuthorizersRequest,
        GetAuthorizersResponse,
        Authorizer
      ](
        "getAuthorizers",
        api.getAuthorizers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.Authorizer.wrap(item))
        .provideEnvironment(r)
    def getAuthorizersPaginated(
        request: zio.aws.apigatewayv2.model.GetAuthorizersRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetAuthorizersResponse.ReadOnly
    ] = asyncRequestResponse[GetAuthorizersRequest, GetAuthorizersResponse](
      "getAuthorizers",
      api.getAuthorizers
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetAuthorizersResponse.wrap)
      .provideEnvironment(r)
    def updateIntegrationResponse(
        request: zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateIntegrationResponseRequest,
      UpdateIntegrationResponseResponse
    ]("updateIntegrationResponse", api.updateIntegrationResponse)(
      request.buildAwsValue()
    ).map(zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.wrap)
      .provideEnvironment(r)
    def createDeployment(
        request: zio.aws.apigatewayv2.model.CreateDeploymentRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.CreateDeploymentResponse.ReadOnly
    ] = asyncRequestResponse[CreateDeploymentRequest, CreateDeploymentResponse](
      "createDeployment",
      api.createDeployment
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.CreateDeploymentResponse.wrap)
      .provideEnvironment(r)
    def getRoute(
        request: zio.aws.apigatewayv2.model.GetRouteRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetRouteResponse.ReadOnly] =
      asyncRequestResponse[GetRouteRequest, GetRouteResponse](
        "getRoute",
        api.getRoute
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetRouteResponse.wrap)
        .provideEnvironment(r)
    def getModelTemplate(
        request: zio.aws.apigatewayv2.model.GetModelTemplateRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetModelTemplateResponse.ReadOnly
    ] = asyncRequestResponse[GetModelTemplateRequest, GetModelTemplateResponse](
      "getModelTemplate",
      api.getModelTemplate
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetModelTemplateResponse.wrap)
      .provideEnvironment(r)
    def createStage(
        request: zio.aws.apigatewayv2.model.CreateStageRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.CreateStageResponse.ReadOnly] =
      asyncRequestResponse[CreateStageRequest, CreateStageResponse](
        "createStage",
        api.createStage
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.CreateStageResponse.wrap)
        .provideEnvironment(r)
    def getApiMapping(
        request: zio.aws.apigatewayv2.model.GetApiMappingRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetApiMappingResponse.ReadOnly] =
      asyncRequestResponse[GetApiMappingRequest, GetApiMappingResponse](
        "getApiMapping",
        api.getApiMapping
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetApiMappingResponse.wrap)
        .provideEnvironment(r)
    def createAuthorizer(
        request: zio.aws.apigatewayv2.model.CreateAuthorizerRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly
    ] = asyncRequestResponse[CreateAuthorizerRequest, CreateAuthorizerResponse](
      "createAuthorizer",
      api.createAuthorizer
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.CreateAuthorizerResponse.wrap)
      .provideEnvironment(r)
    def createRouteResponse(
        request: zio.aws.apigatewayv2.model.CreateRouteResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.CreateRouteResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRouteResponseRequest,
      CreateRouteResponseResponse
    ]("createRouteResponse", api.createRouteResponse)(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.CreateRouteResponseResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.apigatewayv2.model.TagResourceRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getIntegration(
        request: zio.aws.apigatewayv2.model.GetIntegrationRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[GetIntegrationRequest, GetIntegrationResponse](
      "getIntegration",
      api.getIntegration
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetIntegrationResponse.wrap)
      .provideEnvironment(r)
    def createIntegrationResponse(
        request: zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.CreateIntegrationResponseResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateIntegrationResponseRequest,
      CreateIntegrationResponseResponse
    ]("createIntegrationResponse", api.createIntegrationResponse)(
      request.buildAwsValue()
    ).map(zio.aws.apigatewayv2.model.CreateIntegrationResponseResponse.wrap)
      .provideEnvironment(r)
    def getDeployments(
        request: zio.aws.apigatewayv2.model.GetDeploymentsRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Deployment.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetDeploymentsRequest,
        GetDeploymentsResponse,
        Deployment
      ](
        "getDeployments",
        api.getDeployments,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.Deployment.wrap(item))
        .provideEnvironment(r)
    def getDeploymentsPaginated(
        request: zio.aws.apigatewayv2.model.GetDeploymentsRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly
    ] = asyncRequestResponse[GetDeploymentsRequest, GetDeploymentsResponse](
      "getDeployments",
      api.getDeployments
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetDeploymentsResponse.wrap)
      .provideEnvironment(r)
    def updateApiMapping(
        request: zio.aws.apigatewayv2.model.UpdateApiMappingRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly
    ] = asyncRequestResponse[UpdateApiMappingRequest, UpdateApiMappingResponse](
      "updateApiMapping",
      api.updateApiMapping
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.UpdateApiMappingResponse.wrap)
      .provideEnvironment(r)
    def deleteAuthorizer(
        request: zio.aws.apigatewayv2.model.DeleteAuthorizerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAuthorizerRequest, DeleteAuthorizerResponse](
        "deleteAuthorizer",
        api.deleteAuthorizer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteIntegrationResponse(
        request: zio.aws.apigatewayv2.model.DeleteIntegrationResponseRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteIntegrationResponseRequest,
      DeleteIntegrationResponseResponse
    ]("deleteIntegrationResponse", api.deleteIntegrationResponse)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getIntegrationResponses(
        request: zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.IntegrationResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetIntegrationResponsesRequest,
      GetIntegrationResponsesResponse,
      IntegrationResponse
    ](
      "getIntegrationResponses",
      api.getIntegrationResponses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.apigatewayv2.model.IntegrationResponse.wrap(item))
      .provideEnvironment(r)
    def getIntegrationResponsesPaginated(
        request: zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetIntegrationResponsesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetIntegrationResponsesRequest,
      GetIntegrationResponsesResponse
    ]("getIntegrationResponses", api.getIntegrationResponses)(
      request.buildAwsValue()
    ).map(zio.aws.apigatewayv2.model.GetIntegrationResponsesResponse.wrap)
      .provideEnvironment(r)
    def updateIntegration(
        request: zio.aws.apigatewayv2.model.UpdateIntegrationRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.UpdateIntegrationResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateIntegrationRequest, UpdateIntegrationResponse](
        "updateIntegration",
        api.updateIntegration
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.UpdateIntegrationResponse.wrap)
        .provideEnvironment(r)
    def createIntegration(
        request: zio.aws.apigatewayv2.model.CreateIntegrationRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.CreateIntegrationResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateIntegrationRequest, CreateIntegrationResponse](
        "createIntegration",
        api.createIntegration
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.CreateIntegrationResponse.wrap)
        .provideEnvironment(r)
    def getModels(
        request: zio.aws.apigatewayv2.model.GetModelsRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Model.ReadOnly] =
      asyncSimplePaginatedRequest[GetModelsRequest, GetModelsResponse, Model](
        "getModels",
        api.getModels,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.Model.wrap(item))
        .provideEnvironment(r)
    def getModelsPaginated(
        request: zio.aws.apigatewayv2.model.GetModelsRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetModelsResponse.ReadOnly] =
      asyncRequestResponse[GetModelsRequest, GetModelsResponse](
        "getModels",
        api.getModels
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetModelsResponse.wrap)
        .provideEnvironment(r)
    def getStages(
        request: zio.aws.apigatewayv2.model.GetStagesRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Stage.ReadOnly] =
      asyncSimplePaginatedRequest[GetStagesRequest, GetStagesResponse, Stage](
        "getStages",
        api.getStages,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.Stage.wrap(item))
        .provideEnvironment(r)
    def getStagesPaginated(
        request: zio.aws.apigatewayv2.model.GetStagesRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetStagesResponse.ReadOnly] =
      asyncRequestResponse[GetStagesRequest, GetStagesResponse](
        "getStages",
        api.getStages
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetStagesResponse.wrap)
        .provideEnvironment(r)
    def getDomainName(
        request: zio.aws.apigatewayv2.model.GetDomainNameRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetDomainNameResponse.ReadOnly] =
      asyncRequestResponse[GetDomainNameRequest, GetDomainNameResponse](
        "getDomainName",
        api.getDomainName
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetDomainNameResponse.wrap)
        .provideEnvironment(r)
    def getIntegrations(
        request: zio.aws.apigatewayv2.model.GetIntegrationsRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Integration.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetIntegrationsRequest,
        GetIntegrationsResponse,
        Integration
      ](
        "getIntegrations",
        api.getIntegrations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.Integration.wrap(item))
        .provideEnvironment(r)
    def getIntegrationsPaginated(
        request: zio.aws.apigatewayv2.model.GetIntegrationsRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.GetIntegrationsResponse.ReadOnly
    ] = asyncRequestResponse[GetIntegrationsRequest, GetIntegrationsResponse](
      "getIntegrations",
      api.getIntegrations
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.GetIntegrationsResponse.wrap)
      .provideEnvironment(r)
    def getRoutes(
        request: zio.aws.apigatewayv2.model.GetRoutesRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Route.ReadOnly] =
      asyncSimplePaginatedRequest[GetRoutesRequest, GetRoutesResponse, Route](
        "getRoutes",
        api.getRoutes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.Route.wrap(item))
        .provideEnvironment(r)
    def getRoutesPaginated(
        request: zio.aws.apigatewayv2.model.GetRoutesRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetRoutesResponse.ReadOnly] =
      asyncRequestResponse[GetRoutesRequest, GetRoutesResponse](
        "getRoutes",
        api.getRoutes
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetRoutesResponse.wrap)
        .provideEnvironment(r)
    def getAuthorizer(
        request: zio.aws.apigatewayv2.model.GetAuthorizerRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetAuthorizerResponse.ReadOnly] =
      asyncRequestResponse[GetAuthorizerRequest, GetAuthorizerResponse](
        "getAuthorizer",
        api.getAuthorizer
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetAuthorizerResponse.wrap)
        .provideEnvironment(r)
    def deleteDomainName(
        request: zio.aws.apigatewayv2.model.DeleteDomainNameRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDomainNameRequest, DeleteDomainNameResponse](
        "deleteDomainName",
        api.deleteDomainName
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getApis(
        request: zio.aws.apigatewayv2.model.GetApisRequest
    ): ZStream[Any, AwsError, zio.aws.apigatewayv2.model.Api.ReadOnly] =
      asyncSimplePaginatedRequest[GetApisRequest, GetApisResponse, Api](
        "getApis",
        api.getApis,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.apigatewayv2.model.Api.wrap(item))
        .provideEnvironment(r)
    def getApisPaginated(
        request: zio.aws.apigatewayv2.model.GetApisRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetApisResponse.ReadOnly] =
      asyncRequestResponse[GetApisRequest, GetApisResponse](
        "getApis",
        api.getApis
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetApisResponse.wrap)
        .provideEnvironment(r)
    def deleteRouteResponse(
        request: zio.aws.apigatewayv2.model.DeleteRouteResponseRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteRouteResponseRequest,
      DeleteRouteResponseResponse
    ]("deleteRouteResponse", api.deleteRouteResponse)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateDomainName(
        request: zio.aws.apigatewayv2.model.UpdateDomainNameRequest
    ): IO[
      AwsError,
      zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDomainNameRequest, UpdateDomainNameResponse](
      "updateDomainName",
      api.updateDomainName
    )(request.buildAwsValue())
      .map(zio.aws.apigatewayv2.model.UpdateDomainNameResponse.wrap)
      .provideEnvironment(r)
    def getTags(
        request: zio.aws.apigatewayv2.model.GetTagsRequest
    ): IO[AwsError, zio.aws.apigatewayv2.model.GetTagsResponse.ReadOnly] =
      asyncRequestResponse[GetTagsRequest, GetTagsResponse](
        "getTags",
        api.getTags
      )(request.buildAwsValue())
        .map(zio.aws.apigatewayv2.model.GetTagsResponse.wrap)
        .provideEnvironment(r)
  }
  def updateRouteResponse(
      request: zio.aws.apigatewayv2.model.UpdateRouteResponseRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateRouteResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRouteResponse(request))
  def resetAuthorizersCache(
      request: zio.aws.apigatewayv2.model.ResetAuthorizersCacheRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resetAuthorizersCache(request))
  def updateStage(request: zio.aws.apigatewayv2.model.UpdateStageRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStage(request))
  def getVpcLinks(
      request: zio.aws.apigatewayv2.model.GetVpcLinksRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.VpcLink.ReadOnly
  ] = ZStream.serviceWithStream(_.getVpcLinks(request))
  def getVpcLinksPaginated(
      request: zio.aws.apigatewayv2.model.GetVpcLinksRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetVpcLinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpcLinksPaginated(request))
  def createRoute(request: zio.aws.apigatewayv2.model.CreateRouteRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoute(request))
  def deleteRoute(
      request: zio.aws.apigatewayv2.model.DeleteRouteRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRoute(request))
  def importApi(request: zio.aws.apigatewayv2.model.ImportApiRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.ImportApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importApi(request))
  def getRouteResponses(
      request: zio.aws.apigatewayv2.model.GetRouteResponsesRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.RouteResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.getRouteResponses(request))
  def getRouteResponsesPaginated(
      request: zio.aws.apigatewayv2.model.GetRouteResponsesRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetRouteResponsesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRouteResponsesPaginated(request))
  def getDomainNames(
      request: zio.aws.apigatewayv2.model.GetDomainNamesRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.DomainName.ReadOnly
  ] = ZStream.serviceWithStream(_.getDomainNames(request))
  def getDomainNamesPaginated(
      request: zio.aws.apigatewayv2.model.GetDomainNamesRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetDomainNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainNamesPaginated(request))
  def updateRoute(request: zio.aws.apigatewayv2.model.UpdateRouteRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoute(request))
  def getRouteResponse(
      request: zio.aws.apigatewayv2.model.GetRouteResponseRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetRouteResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRouteResponse(request))
  def createModel(request: zio.aws.apigatewayv2.model.CreateModelRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createModel(request))
  def exportApi(request: zio.aws.apigatewayv2.model.ExportApiRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportApi(request))
  def updateModel(request: zio.aws.apigatewayv2.model.UpdateModelRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateModel(request))
  def deleteAccessLogSettings(
      request: zio.aws.apigatewayv2.model.DeleteAccessLogSettingsRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccessLogSettings(request))
  def deleteVpcLink(
      request: zio.aws.apigatewayv2.model.DeleteVpcLinkRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.DeleteVpcLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcLink(request))
  def getVpcLink(request: zio.aws.apigatewayv2.model.GetVpcLinkRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetVpcLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpcLink(request))
  def deleteApi(
      request: zio.aws.apigatewayv2.model.DeleteApiRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApi(request))
  def getDeployment(
      request: zio.aws.apigatewayv2.model.GetDeploymentRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeployment(request))
  def deleteDeployment(
      request: zio.aws.apigatewayv2.model.DeleteDeploymentRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDeployment(request))
  def deleteCorsConfiguration(
      request: zio.aws.apigatewayv2.model.DeleteCorsConfigurationRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCorsConfiguration(request))
  def getStage(request: zio.aws.apigatewayv2.model.GetStageRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStage(request))
  def deleteIntegration(
      request: zio.aws.apigatewayv2.model.DeleteIntegrationRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIntegration(request))
  def updateDeployment(
      request: zio.aws.apigatewayv2.model.UpdateDeploymentRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeployment(request))
  def getIntegrationResponse(
      request: zio.aws.apigatewayv2.model.GetIntegrationResponseRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetIntegrationResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIntegrationResponse(request))
  def getApiMappings(
      request: zio.aws.apigatewayv2.model.GetApiMappingsRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.ApiMapping.ReadOnly
  ] = ZStream.serviceWithStream(_.getApiMappings(request))
  def getApiMappingsPaginated(
      request: zio.aws.apigatewayv2.model.GetApiMappingsRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetApiMappingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApiMappingsPaginated(request))
  def updateVpcLink(
      request: zio.aws.apigatewayv2.model.UpdateVpcLinkRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateVpcLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVpcLink(request))
  def getModel(request: zio.aws.apigatewayv2.model.GetModelRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModel(request))
  def updateAuthorizer(
      request: zio.aws.apigatewayv2.model.UpdateAuthorizerRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateAuthorizer(request))
  def deleteRouteRequestParameter(
      request: zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRouteRequestParameter(request))
  def deleteStage(
      request: zio.aws.apigatewayv2.model.DeleteStageRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStage(request))
  def deleteApiMapping(
      request: zio.aws.apigatewayv2.model.DeleteApiMappingRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApiMapping(request))
  def createApiMapping(
      request: zio.aws.apigatewayv2.model.CreateApiMappingRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateApiMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApiMapping(request))
  def deleteModel(
      request: zio.aws.apigatewayv2.model.DeleteModelRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteModel(request))
  def createDomainName(
      request: zio.aws.apigatewayv2.model.CreateDomainNameRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomainName(request))
  def reimportApi(request: zio.aws.apigatewayv2.model.ReimportApiRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.ReimportApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reimportApi(request))
  def getApi(request: zio.aws.apigatewayv2.model.GetApiRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApi(request))
  def deleteRouteSettings(
      request: zio.aws.apigatewayv2.model.DeleteRouteSettingsRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRouteSettings(request))
  def createApi(request: zio.aws.apigatewayv2.model.CreateApiRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApi(request))
  def createVpcLink(
      request: zio.aws.apigatewayv2.model.CreateVpcLinkRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateVpcLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcLink(request))
  def updateApi(request: zio.aws.apigatewayv2.model.UpdateApiRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateApiResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApi(request))
  def untagResource(
      request: zio.aws.apigatewayv2.model.UntagResourceRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def getAuthorizers(
      request: zio.aws.apigatewayv2.model.GetAuthorizersRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.Authorizer.ReadOnly
  ] = ZStream.serviceWithStream(_.getAuthorizers(request))
  def getAuthorizersPaginated(
      request: zio.aws.apigatewayv2.model.GetAuthorizersRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetAuthorizersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAuthorizersPaginated(request))
  def updateIntegrationResponse(
      request: zio.aws.apigatewayv2.model.UpdateIntegrationResponseRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateIntegrationResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIntegrationResponse(request))
  def createDeployment(
      request: zio.aws.apigatewayv2.model.CreateDeploymentRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeployment(request))
  def getRoute(request: zio.aws.apigatewayv2.model.GetRouteRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoute(request))
  def getModelTemplate(
      request: zio.aws.apigatewayv2.model.GetModelTemplateRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetModelTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelTemplate(request))
  def createStage(request: zio.aws.apigatewayv2.model.CreateStageRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStage(request))
  def getApiMapping(
      request: zio.aws.apigatewayv2.model.GetApiMappingRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetApiMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApiMapping(request))
  def createAuthorizer(
      request: zio.aws.apigatewayv2.model.CreateAuthorizerRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAuthorizer(request))
  def createRouteResponse(
      request: zio.aws.apigatewayv2.model.CreateRouteResponseRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateRouteResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRouteResponse(request))
  def tagResource(request: zio.aws.apigatewayv2.model.TagResourceRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getIntegration(
      request: zio.aws.apigatewayv2.model.GetIntegrationRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIntegration(request))
  def createIntegrationResponse(
      request: zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateIntegrationResponseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIntegrationResponse(request))
  def getDeployments(
      request: zio.aws.apigatewayv2.model.GetDeploymentsRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.Deployment.ReadOnly
  ] = ZStream.serviceWithStream(_.getDeployments(request))
  def getDeploymentsPaginated(
      request: zio.aws.apigatewayv2.model.GetDeploymentsRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetDeploymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeploymentsPaginated(request))
  def updateApiMapping(
      request: zio.aws.apigatewayv2.model.UpdateApiMappingRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateApiMappingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApiMapping(request))
  def deleteAuthorizer(
      request: zio.aws.apigatewayv2.model.DeleteAuthorizerRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAuthorizer(request))
  def deleteIntegrationResponse(
      request: zio.aws.apigatewayv2.model.DeleteIntegrationResponseRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteIntegrationResponse(request))
  def getIntegrationResponses(
      request: zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.IntegrationResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.getIntegrationResponses(request))
  def getIntegrationResponsesPaginated(
      request: zio.aws.apigatewayv2.model.GetIntegrationResponsesRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetIntegrationResponsesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIntegrationResponsesPaginated(request))
  def updateIntegration(
      request: zio.aws.apigatewayv2.model.UpdateIntegrationRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateIntegration(request))
  def createIntegration(
      request: zio.aws.apigatewayv2.model.CreateIntegrationRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.CreateIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIntegration(request))
  def getModels(request: zio.aws.apigatewayv2.model.GetModelsRequest): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.Model.ReadOnly
  ] = ZStream.serviceWithStream(_.getModels(request))
  def getModelsPaginated(
      request: zio.aws.apigatewayv2.model.GetModelsRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetModelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getModelsPaginated(request))
  def getStages(request: zio.aws.apigatewayv2.model.GetStagesRequest): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.Stage.ReadOnly
  ] = ZStream.serviceWithStream(_.getStages(request))
  def getStagesPaginated(
      request: zio.aws.apigatewayv2.model.GetStagesRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetStagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStagesPaginated(request))
  def getDomainName(
      request: zio.aws.apigatewayv2.model.GetDomainNameRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainName(request))
  def getIntegrations(
      request: zio.aws.apigatewayv2.model.GetIntegrationsRequest
  ): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.Integration.ReadOnly
  ] = ZStream.serviceWithStream(_.getIntegrations(request))
  def getIntegrationsPaginated(
      request: zio.aws.apigatewayv2.model.GetIntegrationsRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetIntegrationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIntegrationsPaginated(request))
  def getRoutes(request: zio.aws.apigatewayv2.model.GetRoutesRequest): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.Route.ReadOnly
  ] = ZStream.serviceWithStream(_.getRoutes(request))
  def getRoutesPaginated(
      request: zio.aws.apigatewayv2.model.GetRoutesRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoutesPaginated(request))
  def getAuthorizer(
      request: zio.aws.apigatewayv2.model.GetAuthorizerRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetAuthorizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAuthorizer(request))
  def deleteDomainName(
      request: zio.aws.apigatewayv2.model.DeleteDomainNameRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDomainName(request))
  def getApis(request: zio.aws.apigatewayv2.model.GetApisRequest): ZStream[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.Api.ReadOnly
  ] = ZStream.serviceWithStream(_.getApis(request))
  def getApisPaginated(request: zio.aws.apigatewayv2.model.GetApisRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetApisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApisPaginated(request))
  def deleteRouteResponse(
      request: zio.aws.apigatewayv2.model.DeleteRouteResponseRequest
  ): ZIO[zio.aws.apigatewayv2.ApiGatewayV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRouteResponse(request))
  def updateDomainName(
      request: zio.aws.apigatewayv2.model.UpdateDomainNameRequest
  ): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomainName(request))
  def getTags(request: zio.aws.apigatewayv2.model.GetTagsRequest): ZIO[
    zio.aws.apigatewayv2.ApiGatewayV2,
    AwsError,
    zio.aws.apigatewayv2.model.GetTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTags(request))
}
