package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And64,
  UriWithLengthBetween1And2048
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MutualTlsAuthenticationInput(
    truststoreUri: Optional[UriWithLengthBetween1And2048] = Optional.Absent,
    truststoreVersion: Optional[StringWithLengthBetween1And64] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthenticationInput = {
    import MutualTlsAuthenticationInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthenticationInput
      .builder()
      .optionallyWith(
        truststoreUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.truststoreUri)
      .optionallyWith(
        truststoreVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.truststoreVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly =
    zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput
      .wrap(buildAwsValue())
}
object MutualTlsAuthenticationInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthenticationInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput =
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput(
        truststoreUri.map(value => value),
        truststoreVersion.map(value => value)
      )
    def truststoreUri: Optional[UriWithLengthBetween1And2048]
    def truststoreVersion: Optional[StringWithLengthBetween1And64]
    def getTruststoreUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("truststoreUri", truststoreUri)
    def getTruststoreVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("truststoreVersion", truststoreVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthenticationInput
  ) extends zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly {
    override val truststoreUri: Optional[UriWithLengthBetween1And2048] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truststoreUri())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .UriWithLengthBetween1And2048(value)
        )
    override val truststoreVersion: Optional[StringWithLengthBetween1And64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truststoreVersion())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthenticationInput
  ): zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly =
    new Wrapper(impl)
}
