package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween1And512
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDomainNameRequest(
    domainName: StringWithLengthBetween1And512,
    domainNameConfigurations: Optional[
      Iterable[zio.aws.apigatewayv2.model.DomainNameConfiguration]
    ] = Optional.Absent,
    mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput
    ] = Optional.Absent,
    tags: Optional[Map[__string, StringWithLengthBetween1And1600]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest = {
    import CreateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
      .builder()
      .domainName(
        StringWithLengthBetween1And512.unwrap(domainName): java.lang.String
      )
      .optionallyWith(
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNameConfigurations)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateDomainNameRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateDomainNameRequest.wrap(buildAwsValue())
}
object CreateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateDomainNameRequest =
      zio.aws.apigatewayv2.model.CreateDomainNameRequest(
        domainName,
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mutualTlsAuthentication.map(value => value.asEditable),
        tags.map(value => value)
      )
    def domainName: StringWithLengthBetween1And512
    def domainNameConfigurations: Optional[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ]
    def mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ]
    def tags: Optional[Map[__string, StringWithLengthBetween1And1600]]
    def getDomainName: ZIO[Any, Nothing, StringWithLengthBetween1And512] =
      ZIO.succeed(domainName)
    def getDomainNameConfigurations: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainNameConfigurations",
      domainNameConfigurations
    )
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
  ) extends zio.aws.apigatewayv2.model.CreateDomainNameRequest.ReadOnly {
    override val domainName: StringWithLengthBetween1And512 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And512(impl.domainName())
    override val domainNameConfigurations: Optional[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainNameConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(item)
        }.toList
      )
    override val mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mutualTlsAuthentication())
      .map(value =>
        zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.wrap(value)
      )
    override val tags
        : Optional[Map[__string, StringWithLengthBetween1And1600]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameRequest
  ): zio.aws.apigatewayv2.model.CreateDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
