package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRouteResponsesRequest(
    apiId: __string,
    maxResults: Optional[__string] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    routeId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest = {
    import GetRouteResponsesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(maxResults.map(value => value: java.lang.String))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .routeId(routeId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetRouteResponsesRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetRouteResponsesRequest.wrap(buildAwsValue())
}
object GetRouteResponsesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetRouteResponsesRequest =
      zio.aws.apigatewayv2.model.GetRouteResponsesRequest(
        apiId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        routeId
      )
    def apiId: __string
    def maxResults: Optional[__string]
    def nextToken: Optional[__string]
    def routeId: __string
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
  ) extends zio.aws.apigatewayv2.model.GetRouteResponsesRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val maxResults: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: __string)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val routeId: __string = impl.routeId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRouteResponsesRequest
  ): zio.aws.apigatewayv2.model.GetRouteResponsesRequest.ReadOnly = new Wrapper(
    impl
  )
}
