package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween0And1024,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDeploymentRequest(
    apiId: __string,
    deploymentId: __string,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest = {
    import UpdateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .deploymentId(deploymentId: java.lang.String)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateDeploymentRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateDeploymentRequest.wrap(buildAwsValue())
}
object UpdateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateDeploymentRequest =
      zio.aws.apigatewayv2.model.UpdateDeploymentRequest(
        apiId,
        deploymentId,
        description.map(value => value)
      )
    def apiId: __string
    def deploymentId: __string
    def description: Optional[StringWithLengthBetween0And1024]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getDeploymentId: ZIO[Any, Nothing, __string] = ZIO.succeed(deploymentId)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest
  ) extends zio.aws.apigatewayv2.model.UpdateDeploymentRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val deploymentId: __string = impl.deploymentId(): __string
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDeploymentRequest
  ): zio.aws.apigatewayv2.model.UpdateDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
