package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  SelectionKey,
  SelectionExpression,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RouteResponse(
    modelSelectionExpression: Optional[SelectionExpression] = Optional.Absent,
    responseModels: Optional[Map[__string, StringWithLengthBetween1And128]] =
      Optional.Absent,
    responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
    ] = Optional.Absent,
    routeResponseId: Optional[Id] = Optional.Absent,
    routeResponseKey: SelectionKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.RouteResponse = {
    import RouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.RouteResponse
      .builder()
      .optionallyWith(
        modelSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.modelSelectionExpression)
      .optionallyWith(
        responseModels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And128.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseModels)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        routeResponseId.map(value => Id.unwrap(value): java.lang.String)
      )(_.routeResponseId)
      .routeResponseKey(SelectionKey.unwrap(routeResponseKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.RouteResponse.ReadOnly =
    zio.aws.apigatewayv2.model.RouteResponse.wrap(buildAwsValue())
}
object RouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.RouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.RouteResponse =
      zio.aws.apigatewayv2.model.RouteResponse(
        modelSelectionExpression.map(value => value),
        responseModels.map(value => value),
        responseParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        routeResponseId.map(value => value),
        routeResponseKey
      )
    def modelSelectionExpression: Optional[SelectionExpression]
    def responseModels: Optional[Map[__string, StringWithLengthBetween1And128]]
    def responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ]
    def routeResponseId: Optional[Id]
    def routeResponseKey: SelectionKey
    def getModelSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "modelSelectionExpression",
        modelSelectionExpression
      )
    def getResponseModels
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And128]] =
      AwsError.unwrapOptionField("responseModels", responseModels)
    def getResponseParameters: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly
    ]] = AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getRouteResponseId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("routeResponseId", routeResponseId)
    def getRouteResponseKey: ZIO[Any, Nothing, SelectionKey] =
      ZIO.succeed(routeResponseKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.RouteResponse
  ) extends zio.aws.apigatewayv2.model.RouteResponse.ReadOnly {
    override val modelSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val responseModels
        : Optional[Map[__string, StringWithLengthBetween1And128]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseModels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And128(value)
            })
            .toMap
        )
    override val responseParameters: Optional[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.ParameterConstraints
              .wrap(value)
          })
          .toMap
      )
    override val routeResponseId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.routeResponseId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val routeResponseKey: SelectionKey =
      zio.aws.apigatewayv2.model.primitives
        .SelectionKey(impl.routeResponseKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.RouteResponse
  ): zio.aws.apigatewayv2.model.RouteResponse.ReadOnly = new Wrapper(impl)
}
