package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween1And512,
  SelectionExpression
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDomainNameResponse(
    apiMappingSelectionExpression: Optional[SelectionExpression] =
      Optional.Absent,
    domainName: Optional[StringWithLengthBetween1And512] = Optional.Absent,
    domainNameConfigurations: Optional[
      Iterable[zio.aws.apigatewayv2.model.DomainNameConfiguration]
    ] = Optional.Absent,
    mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthentication
    ] = Optional.Absent,
    tags: Optional[Map[__string, StringWithLengthBetween1And1600]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse = {
    import UpdateDomainNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse
      .builder()
      .optionallyWith(
        apiMappingSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.apiMappingSelectionExpression)
      .optionallyWith(
        domainName.map(value =>
          StringWithLengthBetween1And512.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNameConfigurations)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateDomainNameResponse.wrap(buildAwsValue())
}
object UpdateDomainNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateDomainNameResponse =
      zio.aws.apigatewayv2.model.UpdateDomainNameResponse(
        apiMappingSelectionExpression.map(value => value),
        domainName.map(value => value),
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mutualTlsAuthentication.map(value => value.asEditable),
        tags.map(value => value)
      )
    def apiMappingSelectionExpression: Optional[SelectionExpression]
    def domainName: Optional[StringWithLengthBetween1And512]
    def domainNameConfigurations: Optional[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ]
    def mutualTlsAuthentication
        : Optional[zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly]
    def tags: Optional[Map[__string, StringWithLengthBetween1And1600]]
    def getApiMappingSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "apiMappingSelectionExpression",
      apiMappingSelectionExpression
    )
    def getDomainName: ZIO[Any, AwsError, StringWithLengthBetween1And512] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainNameConfigurations: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainNameConfigurations",
      domainNameConfigurations
    )
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse
  ) extends zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly {
    override val apiMappingSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiMappingSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val domainName: Optional[StringWithLengthBetween1And512] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainName())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And512(value)
        )
    override val domainNameConfigurations: Optional[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainNameConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(item)
        }.toList
      )
    override val mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mutualTlsAuthentication())
      .map(value =>
        zio.aws.apigatewayv2.model.MutualTlsAuthentication.wrap(value)
      )
    override val tags
        : Optional[Map[__string, StringWithLengthBetween1And1600]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameResponse
  ): zio.aws.apigatewayv2.model.UpdateDomainNameResponse.ReadOnly = new Wrapper(
    impl
  )
}
