package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__boolean
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParameterConstraints(
    required: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints = {
    import ParameterConstraints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints
      .builder()
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly =
    zio.aws.apigatewayv2.model.ParameterConstraints.wrap(buildAwsValue())
}
object ParameterConstraints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.ParameterConstraints =
      zio.aws.apigatewayv2.model
        .ParameterConstraints(required.map(value => value))
    def required: Optional[__boolean]
    def getRequired: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("required", required)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints
  ) extends zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly {
    override val required: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ParameterConstraints
  ): zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly = new Wrapper(
    impl
  )
}
