package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And256,
  StringWithLengthBetween0And1024,
  StringWithLengthBetween0And32K,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetModelResponse(
    contentType: Optional[StringWithLengthBetween1And256] = Optional.Absent,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent,
    modelId: Optional[Id] = Optional.Absent,
    name: Optional[StringWithLengthBetween1And128] = Optional.Absent,
    schema: Optional[StringWithLengthBetween0And32K] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse = {
    import GetModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse
      .builder()
      .optionallyWith(
        contentType.map(value =>
          StringWithLengthBetween1And256.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(modelId.map(value => Id.unwrap(value): java.lang.String))(
        _.modelId
      )
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        schema.map(value =>
          StringWithLengthBetween0And32K.unwrap(value): java.lang.String
        )
      )(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetModelResponse.wrap(buildAwsValue())
}
object GetModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetModelResponse =
      zio.aws.apigatewayv2.model.GetModelResponse(
        contentType.map(value => value),
        description.map(value => value),
        modelId.map(value => value),
        name.map(value => value),
        schema.map(value => value)
      )
    def contentType: Optional[StringWithLengthBetween1And256]
    def description: Optional[StringWithLengthBetween0And1024]
    def modelId: Optional[Id]
    def name: Optional[StringWithLengthBetween1And128]
    def schema: Optional[StringWithLengthBetween0And32K]
    def getContentType: ZIO[Any, AwsError, StringWithLengthBetween1And256] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getModelId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("modelId", modelId)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getSchema: ZIO[Any, AwsError, StringWithLengthBetween0And32K] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse
  ) extends zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly {
    override val contentType: Optional[StringWithLengthBetween1And256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And256(value)
        )
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val modelId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.modelId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val name: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
    override val schema: Optional[StringWithLengthBetween0And32K] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schema())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And32K(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetModelResponse
  ): zio.aws.apigatewayv2.model.GetModelResponse.ReadOnly = new Wrapper(impl)
}
