package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait ContentHandlingStrategy {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy
}
object ContentHandlingStrategy {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy
  ): zio.aws.apigatewayv2.model.ContentHandlingStrategy = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy.CONVERT_TO_BINARY =>
      val r = CONVERT_TO_BINARY
      r
    case software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy.CONVERT_TO_TEXT =>
      val r = CONVERT_TO_TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.ContentHandlingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy =
      software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object CONVERT_TO_BINARY
      extends zio.aws.apigatewayv2.model.ContentHandlingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy =
      software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy.CONVERT_TO_BINARY
  }
  case object CONVERT_TO_TEXT
      extends zio.aws.apigatewayv2.model.ContentHandlingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy =
      software.amazon.awssdk.services.apigatewayv2.model.ContentHandlingStrategy.CONVERT_TO_TEXT
  }
}
