package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait ProtocolType {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.ProtocolType
}
object ProtocolType {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.ProtocolType
  ): zio.aws.apigatewayv2.model.ProtocolType = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.ProtocolType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.ProtocolType.WEBSOCKET =>
      val r = WEBSOCKET
      r
    case software.amazon.awssdk.services.apigatewayv2.model.ProtocolType.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.ProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ProtocolType =
      software.amazon.awssdk.services.apigatewayv2.model.ProtocolType.UNKNOWN_TO_SDK_VERSION
  }
  case object WEBSOCKET extends zio.aws.apigatewayv2.model.ProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ProtocolType =
      software.amazon.awssdk.services.apigatewayv2.model.ProtocolType.WEBSOCKET
  }
  case object HTTP extends zio.aws.apigatewayv2.model.ProtocolType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.ProtocolType =
      software.amazon.awssdk.services.apigatewayv2.model.ProtocolType.HTTP
  }
}
