package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait AuthorizationType {
  def unwrap
      : software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType
}
object AuthorizationType {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType
  ): zio.aws.apigatewayv2.model.AuthorizationType = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.AWS_IAM =>
      val r = AWS_IAM
      r
    case software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.JWT =>
      val r = JWT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.AuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType =
      software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.apigatewayv2.model.AuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType =
      software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.NONE
  }
  case object AWS_IAM extends zio.aws.apigatewayv2.model.AuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType =
      software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.AWS_IAM
  }
  case object CUSTOM extends zio.aws.apigatewayv2.model.AuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType =
      software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.CUSTOM
  }
  case object JWT extends zio.aws.apigatewayv2.model.AuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType =
      software.amazon.awssdk.services.apigatewayv2.model.AuthorizationType.JWT
  }
}
