package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  Arn,
  UriWithLengthBetween1And2048,
  SelectionKey,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  SelectionExpression,
  StringWithLengthBetween1And128
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApiRequest(
    apiId: __string,
    apiKeySelectionExpression: Optional[SelectionExpression] = Optional.Absent,
    corsConfiguration: Optional[zio.aws.apigatewayv2.model.Cors] =
      Optional.Absent,
    credentialsArn: Optional[Arn] = Optional.Absent,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent,
    disableSchemaValidation: Optional[__boolean] = Optional.Absent,
    disableExecuteApiEndpoint: Optional[__boolean] = Optional.Absent,
    name: Optional[StringWithLengthBetween1And128] = Optional.Absent,
    routeKey: Optional[SelectionKey] = Optional.Absent,
    routeSelectionExpression: Optional[SelectionExpression] = Optional.Absent,
    target: Optional[UriWithLengthBetween1And2048] = Optional.Absent,
    version: Optional[StringWithLengthBetween1And64] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest = {
    import UpdateApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(
        apiKeySelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.apiKeySelectionExpression)
      .optionallyWith(corsConfiguration.map(value => value.buildAwsValue()))(
        _.corsConfiguration
      )
      .optionallyWith(
        credentialsArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.credentialsArn)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        disableSchemaValidation.map(value => value: java.lang.Boolean)
      )(_.disableSchemaValidation)
      .optionallyWith(
        disableExecuteApiEndpoint.map(value => value: java.lang.Boolean)
      )(_.disableExecuteApiEndpoint)
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        routeKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.routeKey)
      .optionallyWith(
        routeSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.routeSelectionExpression)
      .optionallyWith(
        target.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.target)
      .optionallyWith(
        version.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateApiRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateApiRequest.wrap(buildAwsValue())
}
object UpdateApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateApiRequest =
      zio.aws.apigatewayv2.model.UpdateApiRequest(
        apiId,
        apiKeySelectionExpression.map(value => value),
        corsConfiguration.map(value => value.asEditable),
        credentialsArn.map(value => value),
        description.map(value => value),
        disableSchemaValidation.map(value => value),
        disableExecuteApiEndpoint.map(value => value),
        name.map(value => value),
        routeKey.map(value => value),
        routeSelectionExpression.map(value => value),
        target.map(value => value),
        version.map(value => value)
      )
    def apiId: __string
    def apiKeySelectionExpression: Optional[SelectionExpression]
    def corsConfiguration: Optional[zio.aws.apigatewayv2.model.Cors.ReadOnly]
    def credentialsArn: Optional[Arn]
    def description: Optional[StringWithLengthBetween0And1024]
    def disableSchemaValidation: Optional[__boolean]
    def disableExecuteApiEndpoint: Optional[__boolean]
    def name: Optional[StringWithLengthBetween1And128]
    def routeKey: Optional[SelectionKey]
    def routeSelectionExpression: Optional[SelectionExpression]
    def target: Optional[UriWithLengthBetween1And2048]
    def version: Optional[StringWithLengthBetween1And64]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getApiKeySelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "apiKeySelectionExpression",
        apiKeySelectionExpression
      )
    def getCorsConfiguration
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.Cors.ReadOnly] =
      AwsError.unwrapOptionField("corsConfiguration", corsConfiguration)
    def getCredentialsArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("credentialsArn", credentialsArn)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getDisableSchemaValidation: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableSchemaValidation", disableSchemaValidation)
    def getDisableExecuteApiEndpoint: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableExecuteApiEndpoint", disableExecuteApiEndpoint)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getRouteKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("routeKey", routeKey)
    def getRouteSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "routeSelectionExpression",
        routeSelectionExpression
      )
    def getTarget: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("target", target)
    def getVersion: ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
  ) extends zio.aws.apigatewayv2.model.UpdateApiRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val apiKeySelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKeySelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val corsConfiguration
        : Optional[zio.aws.apigatewayv2.model.Cors.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.corsConfiguration())
        .map(value => zio.aws.apigatewayv2.model.Cors.wrap(value))
    override val credentialsArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.credentialsArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val disableSchemaValidation: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableSchemaValidation())
        .map(value => value: __boolean)
    override val disableExecuteApiEndpoint: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableExecuteApiEndpoint())
        .map(value => value: __boolean)
    override val name: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
    override val routeKey: Optional[SelectionKey] = zio.aws.core.internal
      .optionalFromNullable(impl.routeKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val routeSelectionExpression: Optional[SelectionExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val target: Optional[UriWithLengthBetween1And2048] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .UriWithLengthBetween1And2048(value)
        )
    override val version: Optional[StringWithLengthBetween1And64] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
  ): zio.aws.apigatewayv2.model.UpdateApiRequest.ReadOnly = new Wrapper(impl)
}
