package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  UriWithLengthBetween1And2048,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JWTConfiguration(
    audience: Optional[Iterable[__string]] = Optional.Absent,
    issuer: Optional[UriWithLengthBetween1And2048] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.JWTConfiguration = {
    import JWTConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.JWTConfiguration
      .builder()
      .optionallyWith(
        audience.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.audience)
      .optionallyWith(
        issuer.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.issuer)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly =
    zio.aws.apigatewayv2.model.JWTConfiguration.wrap(buildAwsValue())
}
object JWTConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.JWTConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.JWTConfiguration =
      zio.aws.apigatewayv2.model.JWTConfiguration(
        audience.map(value => value),
        issuer.map(value => value)
      )
    def audience: Optional[List[__string]]
    def issuer: Optional[UriWithLengthBetween1And2048]
    def getAudience: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("audience", audience)
    def getIssuer: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("issuer", issuer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.JWTConfiguration
  ) extends zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly {
    override val audience: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.audience())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val issuer: Optional[UriWithLengthBetween1And2048] =
      zio.aws.core.internal
        .optionalFromNullable(impl.issuer())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .UriWithLengthBetween1And2048(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.JWTConfiguration
  ): zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly = new Wrapper(impl)
}
