package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetVpcLinksRequest(
    maxResults: Option[__string] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest = {
    import GetVpcLinksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.String))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetVpcLinksRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetVpcLinksRequest.wrap(buildAwsValue())
}
object GetVpcLinksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetVpcLinksRequest =
      zio.aws.apigatewayv2.model.GetVpcLinksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[__string]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest
  ) extends zio.aws.apigatewayv2.model.GetVpcLinksRequest.ReadOnly {
    override val maxResults: Option[__string] =
      scala.Option(impl.maxResults()).map(value => value: __string)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetVpcLinksRequest
  ): zio.aws.apigatewayv2.model.GetVpcLinksRequest.ReadOnly = new Wrapper(impl)
}
