package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.ExportedApi
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExportApiResponse(body: Option[ExportedApi] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse = {
    import ExportApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse
      .builder()
      .optionallyWith(
        body.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.body)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly =
    zio.aws.apigatewayv2.model.ExportApiResponse.wrap(buildAwsValue())
}
object ExportApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.ExportApiResponse =
      zio.aws.apigatewayv2.model.ExportApiResponse(body.map(value => value))
    def body: Option[ExportedApi]
    def getBody: ZIO[Any, AwsError, ExportedApi] =
      AwsError.unwrapOptionField("body", body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse
  ) extends zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly {
    override val body: Option[ExportedApi] = scala
      .Option(impl.body())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .ExportedApi(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ExportApiResponse
  ): zio.aws.apigatewayv2.model.ExportApiResponse.ReadOnly = new Wrapper(impl)
}
