package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1024,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccessLogSettings(
    destinationArn: Option[Arn] = None,
    format: Option[StringWithLengthBetween1And1024] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.AccessLogSettings = {
    import AccessLogSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.AccessLogSettings
      .builder()
      .optionallyWith(
        destinationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.destinationArn)
      .optionallyWith(
        format.map(value =>
          StringWithLengthBetween1And1024.unwrap(value): java.lang.String
        )
      )(_.format)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly =
    zio.aws.apigatewayv2.model.AccessLogSettings.wrap(buildAwsValue())
}
object AccessLogSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.AccessLogSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.AccessLogSettings =
      zio.aws.apigatewayv2.model.AccessLogSettings(
        destinationArn.map(value => value),
        format.map(value => value)
      )
    def destinationArn: Option[Arn]
    def format: Option[StringWithLengthBetween1And1024]
    def getDestinationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getFormat: ZIO[Any, AwsError, StringWithLengthBetween1And1024] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.AccessLogSettings
  ) extends zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly {
    override val destinationArn: Option[Arn] = scala
      .Option(impl.destinationArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val format: Option[StringWithLengthBetween1And1024] = scala
      .Option(impl.format())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And1024(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.AccessLogSettings
  ): zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly = new Wrapper(impl)
}
