package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRoutesRequest(
    apiId: __string,
    maxResults: Option[__string] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest = {
    import GetRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(maxResults.map(value => value: java.lang.String))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetRoutesRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetRoutesRequest.wrap(buildAwsValue())
}
object GetRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetRoutesRequest =
      zio.aws.apigatewayv2.model.GetRoutesRequest(
        apiId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def apiId: __string
    def maxResults: Option[__string]
    def nextToken: Option[__string]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest
  ) extends zio.aws.apigatewayv2.model.GetRoutesRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val maxResults: Option[__string] =
      scala.Option(impl.maxResults()).map(value => value: __string)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetRoutesRequest
  ): zio.aws.apigatewayv2.model.GetRoutesRequest.ReadOnly = new Wrapper(impl)
}
