package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetApiMappingsRequest(
    domainName: __string,
    maxResults: Option[__string] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest = {
    import GetApiMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(maxResults.map(value => value: java.lang.String))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetApiMappingsRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetApiMappingsRequest.wrap(buildAwsValue())
}
object GetApiMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetApiMappingsRequest =
      zio.aws.apigatewayv2.model.GetApiMappingsRequest(
        domainName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domainName: __string
    def maxResults: Option[__string]
    def nextToken: Option[__string]
    def getDomainName: ZIO[Any, Nothing, __string] = ZIO.succeed(domainName)
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest
  ) extends zio.aws.apigatewayv2.model.GetApiMappingsRequest.ReadOnly {
    override val domainName: __string = impl.domainName(): __string
    override val maxResults: Option[__string] =
      scala.Option(impl.maxResults()).map(value => value: __string)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetApiMappingsRequest
  ): zio.aws.apigatewayv2.model.GetApiMappingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
