package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait VpcLinkVersion {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion
}
object VpcLinkVersion {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion
  ): zio.aws.apigatewayv2.model.VpcLinkVersion = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion.V2 =>
      val r = V2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.VpcLinkVersion {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion =
      software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object V2 extends zio.aws.apigatewayv2.model.VpcLinkVersion {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion =
      software.amazon.awssdk.services.apigatewayv2.model.VpcLinkVersion.V2
  }
}
