package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween0And2048,
  StringWithLengthBetween1And1600,
  __string,
  __boolean,
  StringWithLengthBetween0And1024,
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetStageResponse(
    accessLogSettings: Option[zio.aws.apigatewayv2.model.AccessLogSettings] =
      None,
    apiGatewayManaged: Option[__boolean] = None,
    autoDeploy: Option[__boolean] = None,
    clientCertificateId: Option[Id] = None,
    createdDate: Option[__timestampIso8601] = None,
    defaultRouteSettings: Option[zio.aws.apigatewayv2.model.RouteSettings] =
      None,
    deploymentId: Option[Id] = None,
    description: Option[StringWithLengthBetween0And1024] = None,
    lastDeploymentStatusMessage: Option[__string] = None,
    lastUpdatedDate: Option[__timestampIso8601] = None,
    routeSettings: Option[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings]
    ] = None,
    stageName: Option[StringWithLengthBetween1And128] = None,
    stageVariables: Option[Map[__string, StringWithLengthBetween0And2048]] =
      None,
    tags: Option[Map[__string, StringWithLengthBetween1And1600]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse = {
    import GetStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse
      .builder()
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(apiGatewayManaged.map(value => value: java.lang.Boolean))(
        _.apiGatewayManaged
      )
      .optionallyWith(autoDeploy.map(value => value: java.lang.Boolean))(
        _.autoDeploy
      )
      .optionallyWith(
        clientCertificateId.map(value => Id.unwrap(value): java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(createdDate.map(value => value: Instant))(_.createdDate)
      .optionallyWith(defaultRouteSettings.map(value => value.buildAwsValue()))(
        _.defaultRouteSettings
      )
      .optionallyWith(
        deploymentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        lastDeploymentStatusMessage.map(value => value: java.lang.String)
      )(_.lastDeploymentStatusMessage)
      .optionallyWith(lastUpdatedDate.map(value => value: Instant))(
        _.lastUpdatedDate
      )
      .optionallyWith(
        routeSettings.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.routeSettings)
      .optionallyWith(
        stageName.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.stageName)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And2048
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly =
    zio.aws.apigatewayv2.model.GetStageResponse.wrap(buildAwsValue())
}
object GetStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetStageResponse =
      zio.aws.apigatewayv2.model.GetStageResponse(
        accessLogSettings.map(value => value.asEditable),
        apiGatewayManaged.map(value => value),
        autoDeploy.map(value => value),
        clientCertificateId.map(value => value),
        createdDate.map(value => value),
        defaultRouteSettings.map(value => value.asEditable),
        deploymentId.map(value => value),
        description.map(value => value),
        lastDeploymentStatusMessage.map(value => value),
        lastUpdatedDate.map(value => value),
        routeSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stageName.map(value => value),
        stageVariables.map(value => value),
        tags.map(value => value)
      )
    def accessLogSettings
        : Option[zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly]
    def apiGatewayManaged: Option[__boolean]
    def autoDeploy: Option[__boolean]
    def clientCertificateId: Option[Id]
    def createdDate: Option[__timestampIso8601]
    def defaultRouteSettings
        : Option[zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    def deploymentId: Option[Id]
    def description: Option[StringWithLengthBetween0And1024]
    def lastDeploymentStatusMessage: Option[__string]
    def lastUpdatedDate: Option[__timestampIso8601]
    def routeSettings: Option[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    ]
    def stageName: Option[StringWithLengthBetween1And128]
    def stageVariables: Option[Map[__string, StringWithLengthBetween0And2048]]
    def tags: Option[Map[__string, StringWithLengthBetween1And1600]]
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getApiGatewayManaged: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
    def getAutoDeploy: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("autoDeploy", autoDeploy)
    def getClientCertificateId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getCreatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDefaultRouteSettings: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.RouteSettings.ReadOnly
    ] = AwsError.unwrapOptionField("defaultRouteSettings", defaultRouteSettings)
    def getDeploymentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getLastDeploymentStatusMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "lastDeploymentStatusMessage",
        lastDeploymentStatusMessage
      )
    def getLastUpdatedDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getRouteSettings: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.RouteSettings.ReadOnly
    ]] = AwsError.unwrapOptionField("routeSettings", routeSettings)
    def getStageName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getStageVariables
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And2048]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse
  ) extends zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly {
    override val accessLogSettings
        : Option[zio.aws.apigatewayv2.model.AccessLogSettings.ReadOnly] = scala
      .Option(impl.accessLogSettings())
      .map(value => zio.aws.apigatewayv2.model.AccessLogSettings.wrap(value))
    override val apiGatewayManaged: Option[__boolean] =
      scala.Option(impl.apiGatewayManaged()).map(value => value: __boolean)
    override val autoDeploy: Option[__boolean] =
      scala.Option(impl.autoDeploy()).map(value => value: __boolean)
    override val clientCertificateId: Option[Id] = scala
      .Option(impl.clientCertificateId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val createdDate: Option[__timestampIso8601] =
      scala.Option(impl.createdDate()).map(value => value: __timestampIso8601)
    override val defaultRouteSettings
        : Option[zio.aws.apigatewayv2.model.RouteSettings.ReadOnly] = scala
      .Option(impl.defaultRouteSettings())
      .map(value => zio.aws.apigatewayv2.model.RouteSettings.wrap(value))
    override val deploymentId: Option[Id] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val lastDeploymentStatusMessage: Option[__string] = scala
      .Option(impl.lastDeploymentStatusMessage())
      .map(value => value: __string)
    override val lastUpdatedDate: Option[__timestampIso8601] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => value: __timestampIso8601)
    override val routeSettings: Option[
      Map[__string, zio.aws.apigatewayv2.model.RouteSettings.ReadOnly]
    ] = scala
      .Option(impl.routeSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.RouteSettings
              .wrap(value)
          })
          .toMap
      )
    override val stageName: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.stageName())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
    override val stageVariables
        : Option[Map[__string, StringWithLengthBetween0And2048]] = scala
      .Option(impl.stageVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween0And2048(value)
          })
          .toMap
      )
    override val tags: Option[Map[__string, StringWithLengthBetween1And1600]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetStageResponse
  ): zio.aws.apigatewayv2.model.GetStageResponse.ReadOnly = new Wrapper(impl)
}
