package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And1600,
  __string,
  StringWithLengthBetween1And512,
  SelectionExpression
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDomainNameResponse(
    apiMappingSelectionExpression: Option[SelectionExpression] = None,
    domainName: Option[StringWithLengthBetween1And512] = None,
    domainNameConfigurations: Option[
      Iterable[zio.aws.apigatewayv2.model.DomainNameConfiguration]
    ] = None,
    mutualTlsAuthentication: Option[
      zio.aws.apigatewayv2.model.MutualTlsAuthentication
    ] = None,
    tags: Option[Map[__string, StringWithLengthBetween1And1600]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse = {
    import CreateDomainNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse
      .builder()
      .optionallyWith(
        apiMappingSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.apiMappingSelectionExpression)
      .optionallyWith(
        domainName.map(value =>
          StringWithLengthBetween1And512.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNameConfigurations)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And1600
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly =
    zio.aws.apigatewayv2.model.CreateDomainNameResponse.wrap(buildAwsValue())
}
object CreateDomainNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateDomainNameResponse =
      zio.aws.apigatewayv2.model.CreateDomainNameResponse(
        apiMappingSelectionExpression.map(value => value),
        domainName.map(value => value),
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mutualTlsAuthentication.map(value => value.asEditable),
        tags.map(value => value)
      )
    def apiMappingSelectionExpression: Option[SelectionExpression]
    def domainName: Option[StringWithLengthBetween1And512]
    def domainNameConfigurations: Option[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ]
    def mutualTlsAuthentication
        : Option[zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly]
    def tags: Option[Map[__string, StringWithLengthBetween1And1600]]
    def getApiMappingSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "apiMappingSelectionExpression",
      apiMappingSelectionExpression
    )
    def getDomainName: ZIO[Any, AwsError, StringWithLengthBetween1And512] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainNameConfigurations: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainNameConfigurations",
      domainNameConfigurations
    )
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
    def getTags
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And1600]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse
  ) extends zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly {
    override val apiMappingSelectionExpression: Option[SelectionExpression] =
      scala
        .Option(impl.apiMappingSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val domainName: Option[StringWithLengthBetween1And512] = scala
      .Option(impl.domainName())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And512(value)
      )
    override val domainNameConfigurations: Option[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ] = scala
      .Option(impl.domainNameConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(item)
        }.toList
      )
    override val mutualTlsAuthentication
        : Option[zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly] =
      scala
        .Option(impl.mutualTlsAuthentication())
        .map(value =>
          zio.aws.apigatewayv2.model.MutualTlsAuthentication.wrap(value)
        )
    override val tags: Option[Map[__string, StringWithLengthBetween1And1600]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> zio.aws.apigatewayv2.model.primitives
                .StringWithLengthBetween1And1600(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDomainNameResponse
  ): zio.aws.apigatewayv2.model.CreateDomainNameResponse.ReadOnly = new Wrapper(
    impl
  )
}
