package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDomainNamesRequest(
    maxResults: Option[__string] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest = {
    import GetDomainNamesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.String))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.GetDomainNamesRequest.ReadOnly =
    zio.aws.apigatewayv2.model.GetDomainNamesRequest.wrap(buildAwsValue())
}
object GetDomainNamesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.GetDomainNamesRequest =
      zio.aws.apigatewayv2.model.GetDomainNamesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[__string]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
  ) extends zio.aws.apigatewayv2.model.GetDomainNamesRequest.ReadOnly {
    override val maxResults: Option[__string] =
      scala.Option(impl.maxResults()).map(value => value: __string)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.GetDomainNamesRequest
  ): zio.aws.apigatewayv2.model.GetDomainNamesRequest.ReadOnly = new Wrapper(
    impl
  )
}
