package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  SelectionKey,
  StringWithLengthBetween1And64,
  SelectionExpression,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRouteResponse(
    apiGatewayManaged: Option[__boolean] = None,
    apiKeyRequired: Option[__boolean] = None,
    authorizationScopes: Option[Iterable[StringWithLengthBetween1And64]] = None,
    authorizationType: Option[zio.aws.apigatewayv2.model.AuthorizationType] =
      None,
    authorizerId: Option[Id] = None,
    modelSelectionExpression: Option[SelectionExpression] = None,
    operationName: Option[StringWithLengthBetween1And64] = None,
    requestModels: Option[Map[__string, StringWithLengthBetween1And128]] = None,
    requestParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
    ] = None,
    routeId: Option[Id] = None,
    routeKey: Option[SelectionKey] = None,
    routeResponseSelectionExpression: Option[SelectionExpression] = None,
    target: Option[StringWithLengthBetween1And128] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse = {
    import UpdateRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse
      .builder()
      .optionallyWith(
        apiGatewayManaged.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.apiGatewayManaged)
      .optionallyWith(
        apiKeyRequired.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.apiKeyRequired)
      .optionallyWith(
        authorizationScopes.map(value =>
          value.map { item =>
            StringWithLengthBetween1And64.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.authorizationScopes)
      .optionallyWith(authorizationType.map(value => value.unwrap))(
        _.authorizationType
      )
      .optionallyWith(
        authorizerId.map(value => Id.unwrap(value): java.lang.String)
      )(_.authorizerId)
      .optionallyWith(
        modelSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.modelSelectionExpression)
      .optionallyWith(
        operationName.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.operationName)
      .optionallyWith(
        requestModels.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And128.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.requestModels)
      .optionallyWith(
        requestParameters.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.requestParameters)
      .optionallyWith(routeId.map(value => Id.unwrap(value): java.lang.String))(
        _.routeId
      )
      .optionallyWith(
        routeKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.routeKey)
      .optionallyWith(
        routeResponseSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.routeResponseSelectionExpression)
      .optionallyWith(
        target.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.target)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateRouteResponse.wrap(buildAwsValue())
}
object UpdateRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateRouteResponse =
      zio.aws.apigatewayv2.model.UpdateRouteResponse(
        apiGatewayManaged.map(value => value),
        apiKeyRequired.map(value => value),
        authorizationScopes.map(value => value),
        authorizationType.map(value => value),
        authorizerId.map(value => value),
        modelSelectionExpression.map(value => value),
        operationName.map(value => value),
        requestModels.map(value => value),
        requestParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        routeId.map(value => value),
        routeKey.map(value => value),
        routeResponseSelectionExpression.map(value => value),
        target.map(value => value)
      )
    def apiGatewayManaged: Option[__boolean]
    def apiKeyRequired: Option[__boolean]
    def authorizationScopes: Option[List[StringWithLengthBetween1And64]]
    def authorizationType: Option[zio.aws.apigatewayv2.model.AuthorizationType]
    def authorizerId: Option[Id]
    def modelSelectionExpression: Option[SelectionExpression]
    def operationName: Option[StringWithLengthBetween1And64]
    def requestModels: Option[Map[__string, StringWithLengthBetween1And128]]
    def requestParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ]
    def routeId: Option[Id]
    def routeKey: Option[SelectionKey]
    def routeResponseSelectionExpression: Option[SelectionExpression]
    def target: Option[StringWithLengthBetween1And128]
    def getApiGatewayManaged: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
    def getApiKeyRequired: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("apiKeyRequired", apiKeyRequired)
    def getAuthorizationScopes
        : ZIO[Any, AwsError, List[StringWithLengthBetween1And64]] =
      AwsError.unwrapOptionField("authorizationScopes", authorizationScopes)
    def getAuthorizationType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.AuthorizationType] =
      AwsError.unwrapOptionField("authorizationType", authorizationType)
    def getAuthorizerId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("authorizerId", authorizerId)
    def getModelSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "modelSelectionExpression",
        modelSelectionExpression
      )
    def getOperationName: ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("operationName", operationName)
    def getRequestModels
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And128]] =
      AwsError.unwrapOptionField("requestModels", requestModels)
    def getRequestParameters: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly
    ]] = AwsError.unwrapOptionField("requestParameters", requestParameters)
    def getRouteId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("routeId", routeId)
    def getRouteKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("routeKey", routeKey)
    def getRouteResponseSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "routeResponseSelectionExpression",
      routeResponseSelectionExpression
    )
    def getTarget: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse
  ) extends zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly {
    override val apiGatewayManaged: Option[__boolean] = scala
      .Option(impl.apiGatewayManaged())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val apiKeyRequired: Option[__boolean] = scala
      .Option(impl.apiKeyRequired())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val authorizationScopes
        : Option[List[StringWithLengthBetween1And64]] = scala
      .Option(impl.authorizationScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(item)
        }.toList
      )
    override val authorizationType
        : Option[zio.aws.apigatewayv2.model.AuthorizationType] = scala
      .Option(impl.authorizationType())
      .map(value => zio.aws.apigatewayv2.model.AuthorizationType.wrap(value))
    override val authorizerId: Option[Id] = scala
      .Option(impl.authorizerId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val modelSelectionExpression: Option[SelectionExpression] = scala
      .Option(impl.modelSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val operationName: Option[StringWithLengthBetween1And64] = scala
      .Option(impl.operationName())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And64(value)
      )
    override val requestModels
        : Option[Map[__string, StringWithLengthBetween1And128]] = scala
      .Option(impl.requestModels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives
              .__string(key) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And128(value)
          })
          .toMap
      )
    override val requestParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ] = scala
      .Option(impl.requestParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives.__string(
              key
            ) -> zio.aws.apigatewayv2.model.ParameterConstraints.wrap(value)
          })
          .toMap
      )
    override val routeId: Option[Id] = scala
      .Option(impl.routeId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val routeKey: Option[SelectionKey] = scala
      .Option(impl.routeKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val routeResponseSelectionExpression: Option[SelectionExpression] =
      scala
        .Option(impl.routeResponseSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
    override val target: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.target())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponse
  ): zio.aws.apigatewayv2.model.UpdateRouteResponse.ReadOnly = new Wrapper(impl)
}
