package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReimportApiRequest(
    apiId: __string,
    basepath: Option[__string] = None,
    body: __string,
    failOnWarnings: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest = {
    import ReimportApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .optionallyWith(
        basepath.map(value => __string.unwrap(value): java.lang.String)
      )(_.basepath)
      .body(__string.unwrap(body): java.lang.String)
      .optionallyWith(
        failOnWarnings.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.failOnWarnings)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.ReimportApiRequest.ReadOnly =
    zio.aws.apigatewayv2.model.ReimportApiRequest.wrap(buildAwsValue())
}
object ReimportApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.ReimportApiRequest =
      zio.aws.apigatewayv2.model.ReimportApiRequest(
        apiId,
        basepath.map(value => value),
        body,
        failOnWarnings.map(value => value)
      )
    def apiId: __string
    def basepath: Option[__string]
    def body: __string
    def failOnWarnings: Option[__boolean]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getBasepath: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("basepath", basepath)
    def getBody: ZIO[Any, Nothing, __string] = ZIO.succeed(body)
    def getFailOnWarnings: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("failOnWarnings", failOnWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
  ) extends zio.aws.apigatewayv2.model.ReimportApiRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val basepath: Option[__string] = scala
      .Option(impl.basepath())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val body: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.body())
    override val failOnWarnings: Option[__boolean] = scala
      .Option(impl.failOnWarnings())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
  ): zio.aws.apigatewayv2.model.ReimportApiRequest.ReadOnly = new Wrapper(impl)
}
