package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __timestampIso8601,
  StringWithLengthBetween1And128,
  Arn,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DomainNameConfiguration(
    apiGatewayDomainName: Option[__string] = None,
    certificateArn: Option[Arn] = None,
    certificateName: Option[StringWithLengthBetween1And128] = None,
    certificateUploadDate: Option[__timestampIso8601] = None,
    domainNameStatus: Option[zio.aws.apigatewayv2.model.DomainNameStatus] =
      None,
    domainNameStatusMessage: Option[__string] = None,
    endpointType: Option[zio.aws.apigatewayv2.model.EndpointType] = None,
    hostedZoneId: Option[__string] = None,
    securityPolicy: Option[zio.aws.apigatewayv2.model.SecurityPolicy] = None,
    ownershipVerificationCertificateArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration = {
    import DomainNameConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
      .builder()
      .optionallyWith(
        apiGatewayDomainName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.apiGatewayDomainName)
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        certificateName.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(
        certificateUploadDate.map(value =>
          __timestampIso8601.unwrap(value): Instant
        )
      )(_.certificateUploadDate)
      .optionallyWith(domainNameStatus.map(value => value.unwrap))(
        _.domainNameStatus
      )
      .optionallyWith(
        domainNameStatusMessage.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.domainNameStatusMessage)
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        hostedZoneId.map(value => __string.unwrap(value): java.lang.String)
      )(_.hostedZoneId)
      .optionallyWith(securityPolicy.map(value => value.unwrap))(
        _.securityPolicy
      )
      .optionallyWith(
        ownershipVerificationCertificateArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.ownershipVerificationCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly =
    zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(buildAwsValue())
}
object DomainNameConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.DomainNameConfiguration =
      zio.aws.apigatewayv2.model.DomainNameConfiguration(
        apiGatewayDomainName.map(value => value),
        certificateArn.map(value => value),
        certificateName.map(value => value),
        certificateUploadDate.map(value => value),
        domainNameStatus.map(value => value),
        domainNameStatusMessage.map(value => value),
        endpointType.map(value => value),
        hostedZoneId.map(value => value),
        securityPolicy.map(value => value),
        ownershipVerificationCertificateArn.map(value => value)
      )
    def apiGatewayDomainName: Option[__string]
    def certificateArn: Option[Arn]
    def certificateName: Option[StringWithLengthBetween1And128]
    def certificateUploadDate: Option[__timestampIso8601]
    def domainNameStatus: Option[zio.aws.apigatewayv2.model.DomainNameStatus]
    def domainNameStatusMessage: Option[__string]
    def endpointType: Option[zio.aws.apigatewayv2.model.EndpointType]
    def hostedZoneId: Option[__string]
    def securityPolicy: Option[zio.aws.apigatewayv2.model.SecurityPolicy]
    def ownershipVerificationCertificateArn: Option[Arn]
    def getApiGatewayDomainName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("apiGatewayDomainName", apiGatewayDomainName)
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getCertificateUploadDate: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("certificateUploadDate", certificateUploadDate)
    def getDomainNameStatus
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.DomainNameStatus] =
      AwsError.unwrapOptionField("domainNameStatus", domainNameStatus)
    def getDomainNameStatusMessage: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("domainNameStatusMessage", domainNameStatusMessage)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getHostedZoneId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.SecurityPolicy] =
      AwsError.unwrapOptionField("securityPolicy", securityPolicy)
    def getOwnershipVerificationCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "ownershipVerificationCertificateArn",
        ownershipVerificationCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
  ) extends zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly {
    override val apiGatewayDomainName: Option[__string] = scala
      .Option(impl.apiGatewayDomainName())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val certificateArn: Option[Arn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val certificateName: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.certificateName())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
    override val certificateUploadDate: Option[__timestampIso8601] = scala
      .Option(impl.certificateUploadDate())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.__timestampIso8601(value)
      )
    override val domainNameStatus
        : Option[zio.aws.apigatewayv2.model.DomainNameStatus] = scala
      .Option(impl.domainNameStatus())
      .map(value => zio.aws.apigatewayv2.model.DomainNameStatus.wrap(value))
    override val domainNameStatusMessage: Option[__string] = scala
      .Option(impl.domainNameStatusMessage())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val endpointType: Option[zio.aws.apigatewayv2.model.EndpointType] =
      scala
        .Option(impl.endpointType())
        .map(value => zio.aws.apigatewayv2.model.EndpointType.wrap(value))
    override val hostedZoneId: Option[__string] = scala
      .Option(impl.hostedZoneId())
      .map(value => zio.aws.apigatewayv2.model.primitives.__string(value))
    override val securityPolicy
        : Option[zio.aws.apigatewayv2.model.SecurityPolicy] = scala
      .Option(impl.securityPolicy())
      .map(value => zio.aws.apigatewayv2.model.SecurityPolicy.wrap(value))
    override val ownershipVerificationCertificateArn: Option[Arn] = scala
      .Option(impl.ownershipVerificationCertificateArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration
  ): zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
