package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  SelectionKey,
  StringWithLengthBetween1And128,
  SelectionExpression,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateRouteResponseRequest(
    apiId: __string,
    modelSelectionExpression: Option[SelectionExpression] = None,
    responseModels: Option[Map[__string, StringWithLengthBetween1And128]] =
      None,
    responseParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints]
    ] = None,
    routeId: __string,
    routeResponseId: __string,
    routeResponseKey: Option[SelectionKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest = {
    import UpdateRouteResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .optionallyWith(
        modelSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.modelSelectionExpression)
      .optionallyWith(
        responseModels.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(
                key
              ): java.lang.String) -> (StringWithLengthBetween1And128.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseModels)
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.responseParameters)
      .routeId(__string.unwrap(routeId): java.lang.String)
      .routeResponseId(__string.unwrap(routeResponseId): java.lang.String)
      .optionallyWith(
        routeResponseKey.map(value =>
          SelectionKey.unwrap(value): java.lang.String
        )
      )(_.routeResponseKey)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.wrap(buildAwsValue())
}
object UpdateRouteResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateRouteResponseRequest =
      zio.aws.apigatewayv2.model.UpdateRouteResponseRequest(
        apiId,
        modelSelectionExpression.map(value => value),
        responseModels.map(value => value),
        responseParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        routeId,
        routeResponseId,
        routeResponseKey.map(value => value)
      )
    def apiId: __string
    def modelSelectionExpression: Option[SelectionExpression]
    def responseModels: Option[Map[__string, StringWithLengthBetween1And128]]
    def responseParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ]
    def routeId: __string
    def routeResponseId: __string
    def routeResponseKey: Option[SelectionKey]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getModelSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "modelSelectionExpression",
        modelSelectionExpression
      )
    def getResponseModels
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And128]] =
      AwsError.unwrapOptionField("responseModels", responseModels)
    def getResponseParameters: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly
    ]] = AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
    def getRouteResponseId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(routeResponseId)
    def getRouteResponseKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("routeResponseKey", routeResponseKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
  ) extends zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val modelSelectionExpression: Option[SelectionExpression] = scala
      .Option(impl.modelSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val responseModels
        : Option[Map[__string, StringWithLengthBetween1And128]] = scala
      .Option(impl.responseModels())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives
              .__string(key) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And128(value)
          })
          .toMap
      )
    override val responseParameters: Option[
      Map[__string, zio.aws.apigatewayv2.model.ParameterConstraints.ReadOnly]
    ] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.apigatewayv2.model.primitives.__string(
              key
            ) -> zio.aws.apigatewayv2.model.ParameterConstraints.wrap(value)
          })
          .toMap
      )
    override val routeId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeId())
    override val routeResponseId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeResponseId())
    override val routeResponseKey: Option[SelectionKey] = scala
      .Option(impl.routeResponseKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateRouteResponseRequest
  ): zio.aws.apigatewayv2.model.UpdateRouteResponseRequest.ReadOnly =
    new Wrapper(impl)
}
