package zio.aws.apigatewayv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  IntegerWithLengthBetween0And3600,
  __string,
  __boolean,
  Arn,
  UriWithLengthBetween1And2048,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  StringWithLengthBetween1And128,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAuthorizerResponse(
    authorizerCredentialsArn: Option[Arn] = None,
    authorizerId: Option[Id] = None,
    authorizerPayloadFormatVersion: Option[StringWithLengthBetween1And64] =
      None,
    authorizerResultTtlInSeconds: Option[IntegerWithLengthBetween0And3600] =
      None,
    authorizerType: Option[zio.aws.apigatewayv2.model.AuthorizerType] = None,
    authorizerUri: Option[UriWithLengthBetween1And2048] = None,
    enableSimpleResponses: Option[__boolean] = None,
    identitySource: Option[Iterable[__string]] = None,
    identityValidationExpression: Option[StringWithLengthBetween0And1024] =
      None,
    jwtConfiguration: Option[zio.aws.apigatewayv2.model.JWTConfiguration] =
      None,
    name: Option[StringWithLengthBetween1And128] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse = {
    import CreateAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
      .builder()
      .optionallyWith(
        authorizerCredentialsArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.authorizerCredentialsArn)
      .optionallyWith(
        authorizerId.map(value => Id.unwrap(value): java.lang.String)
      )(_.authorizerId)
      .optionallyWith(
        authorizerPayloadFormatVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.authorizerPayloadFormatVersion)
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value =>
          IntegerWithLengthBetween0And3600.unwrap(value): Integer
        )
      )(_.authorizerResultTtlInSeconds)
      .optionallyWith(authorizerType.map(value => value.unwrap))(
        _.authorizerType
      )
      .optionallyWith(
        authorizerUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.authorizerUri)
      .optionallyWith(
        enableSimpleResponses.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.enableSimpleResponses)
      .optionallyWith(
        identitySource.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.identitySource)
      .optionallyWith(
        identityValidationExpression.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.identityValidationExpression)
      .optionallyWith(jwtConfiguration.map(value => value.buildAwsValue()))(
        _.jwtConfiguration
      )
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly =
    zio.aws.apigatewayv2.model.CreateAuthorizerResponse.wrap(buildAwsValue())
}
object CreateAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateAuthorizerResponse =
      zio.aws.apigatewayv2.model.CreateAuthorizerResponse(
        authorizerCredentialsArn.map(value => value),
        authorizerId.map(value => value),
        authorizerPayloadFormatVersion.map(value => value),
        authorizerResultTtlInSeconds.map(value => value),
        authorizerType.map(value => value),
        authorizerUri.map(value => value),
        enableSimpleResponses.map(value => value),
        identitySource.map(value => value),
        identityValidationExpression.map(value => value),
        jwtConfiguration.map(value => value.asEditable),
        name.map(value => value)
      )
    def authorizerCredentialsArn: Option[Arn]
    def authorizerId: Option[Id]
    def authorizerPayloadFormatVersion: Option[StringWithLengthBetween1And64]
    def authorizerResultTtlInSeconds: Option[IntegerWithLengthBetween0And3600]
    def authorizerType: Option[zio.aws.apigatewayv2.model.AuthorizerType]
    def authorizerUri: Option[UriWithLengthBetween1And2048]
    def enableSimpleResponses: Option[__boolean]
    def identitySource: Option[List[__string]]
    def identityValidationExpression: Option[StringWithLengthBetween0And1024]
    def jwtConfiguration
        : Option[zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly]
    def name: Option[StringWithLengthBetween1And128]
    def getAuthorizerCredentialsArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("authorizerCredentialsArn", authorizerCredentialsArn)
    def getAuthorizerId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("authorizerId", authorizerId)
    def getAuthorizerPayloadFormatVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField(
        "authorizerPayloadFormatVersion",
        authorizerPayloadFormatVersion
      )
    def getAuthorizerResultTtlInSeconds
        : ZIO[Any, AwsError, IntegerWithLengthBetween0And3600] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
    def getAuthorizerType
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.AuthorizerType] =
      AwsError.unwrapOptionField("authorizerType", authorizerType)
    def getAuthorizerUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getEnableSimpleResponses: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enableSimpleResponses", enableSimpleResponses)
    def getIdentitySource: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("identitySource", identitySource)
    def getIdentityValidationExpression
        : ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
    def getJwtConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("jwtConfiguration", jwtConfiguration)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
  ) extends zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly {
    override val authorizerCredentialsArn: Option[Arn] = scala
      .Option(impl.authorizerCredentialsArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val authorizerId: Option[Id] = scala
      .Option(impl.authorizerId())
      .map(value => zio.aws.apigatewayv2.model.primitives.Id(value))
    override val authorizerPayloadFormatVersion
        : Option[StringWithLengthBetween1And64] = scala
      .Option(impl.authorizerPayloadFormatVersion())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And64(value)
      )
    override val authorizerResultTtlInSeconds
        : Option[IntegerWithLengthBetween0And3600] = scala
      .Option(impl.authorizerResultTtlInSeconds())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .IntegerWithLengthBetween0And3600(value)
      )
    override val authorizerType
        : Option[zio.aws.apigatewayv2.model.AuthorizerType] = scala
      .Option(impl.authorizerType())
      .map(value => zio.aws.apigatewayv2.model.AuthorizerType.wrap(value))
    override val authorizerUri: Option[UriWithLengthBetween1And2048] = scala
      .Option(impl.authorizerUri())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .UriWithLengthBetween1And2048(value)
      )
    override val enableSimpleResponses: Option[__boolean] = scala
      .Option(impl.enableSimpleResponses())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val identitySource: Option[List[__string]] = scala
      .Option(impl.identitySource())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.primitives.__string(item)
        }.toList
      )
    override val identityValidationExpression
        : Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.identityValidationExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val jwtConfiguration
        : Option[zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly] = scala
      .Option(impl.jwtConfiguration())
      .map(value => zio.aws.apigatewayv2.model.JWTConfiguration.wrap(value))
    override val name: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerResponse
  ): zio.aws.apigatewayv2.model.CreateAuthorizerResponse.ReadOnly = new Wrapper(
    impl
  )
}
