package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRouteRequestParameterRequest(
    apiId: __string,
    requestParameterKey: __string,
    routeId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest = {
    import DeleteRouteRequestParameterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .requestParameterKey(
        __string.unwrap(requestParameterKey): java.lang.String
      )
      .routeId(__string.unwrap(routeId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest.ReadOnly =
    zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest
      .wrap(buildAwsValue())
}
object DeleteRouteRequestParameterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest =
      zio.aws.apigatewayv2.model
        .DeleteRouteRequestParameterRequest(apiId, requestParameterKey, routeId)
    def apiId: __string
    def requestParameterKey: __string
    def routeId: __string
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getRequestParameterKey: ZIO[Any, Nothing, __string] =
      ZIO.succeed(requestParameterKey)
    def getRouteId: ZIO[Any, Nothing, __string] = ZIO.succeed(routeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest
  ) extends zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val requestParameterKey: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.requestParameterKey())
    override val routeId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.routeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.DeleteRouteRequestParameterRequest
  ): zio.aws.apigatewayv2.model.DeleteRouteRequestParameterRequest.ReadOnly =
    new Wrapper(impl)
}
