package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And128,
  SelectionKey,
  __string,
  Id
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateApiMappingRequest(
    apiId: Id,
    apiMappingId: __string,
    apiMappingKey: Option[SelectionKey] = None,
    domainName: __string,
    stage: Option[StringWithLengthBetween1And128] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest = {
    import UpdateApiMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest
      .builder()
      .apiId(Id.unwrap(apiId): java.lang.String)
      .apiMappingId(__string.unwrap(apiMappingId): java.lang.String)
      .optionallyWith(
        apiMappingKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.apiMappingKey)
      .domainName(__string.unwrap(domainName): java.lang.String)
      .optionallyWith(
        stage.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateApiMappingRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateApiMappingRequest.wrap(buildAwsValue())
}
object UpdateApiMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateApiMappingRequest =
      zio.aws.apigatewayv2.model.UpdateApiMappingRequest(
        apiId,
        apiMappingId,
        apiMappingKey.map(value => value),
        domainName,
        stage.map(value => value)
      )
    def apiId: Id
    def apiMappingId: __string
    def apiMappingKey: Option[SelectionKey]
    def domainName: __string
    def stage: Option[StringWithLengthBetween1And128]
    def getApiId: ZIO[Any, Nothing, Id] = ZIO.succeed(apiId)
    def getApiMappingId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiMappingId)
    def getApiMappingKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("apiMappingKey", apiMappingKey)
    def getDomainName: ZIO[Any, Nothing, __string] = ZIO.succeed(domainName)
    def getStage: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest
  ) extends zio.aws.apigatewayv2.model.UpdateApiMappingRequest.ReadOnly {
    override val apiId: Id =
      zio.aws.apigatewayv2.model.primitives.Id(impl.apiId())
    override val apiMappingId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiMappingId())
    override val apiMappingKey: Option[SelectionKey] = scala
      .Option(impl.apiMappingKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val domainName: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.domainName())
    override val stage: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.stage())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiMappingRequest
  ): zio.aws.apigatewayv2.model.UpdateApiMappingRequest.ReadOnly = new Wrapper(
    impl
  )
}
