package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  StringWithLengthBetween1And128
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateVpcLinkRequest(
    name: Option[StringWithLengthBetween1And128] = None,
    vpcLinkId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest = {
    import UpdateVpcLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
      .builder()
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .vpcLinkId(__string.unwrap(vpcLinkId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.wrap(buildAwsValue())
}
object UpdateVpcLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateVpcLinkRequest =
      zio.aws.apigatewayv2.model
        .UpdateVpcLinkRequest(name.map(value => value), vpcLinkId)
    def name: Option[StringWithLengthBetween1And128]
    def vpcLinkId: __string
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getVpcLinkId: ZIO[Any, Nothing, __string] = ZIO.succeed(vpcLinkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
  ) extends zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.ReadOnly {
    override val name: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
    override val vpcLinkId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.vpcLinkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateVpcLinkRequest
  ): zio.aws.apigatewayv2.model.UpdateVpcLinkRequest.ReadOnly = new Wrapper(
    impl
  )
}
