package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: __string,
    tagKeys: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest
      .builder()
      .resourceArn(__string.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UntagResourceRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UntagResourceRequest =
      zio.aws.apigatewayv2.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: __string
    def tagKeys: List[__string]
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest
  ) extends zio.aws.apigatewayv2.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.resourceArn())
    override val tagKeys: List[__string] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.apigatewayv2.model.primitives.__string(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UntagResourceRequest
  ): zio.aws.apigatewayv2.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
