package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  StringWithLengthBetween1And64,
  UriWithLengthBetween1And2048
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MutualTlsAuthentication(
    truststoreUri: Option[UriWithLengthBetween1And2048] = None,
    truststoreVersion: Option[StringWithLengthBetween1And64] = None,
    truststoreWarnings: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication = {
    import MutualTlsAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
      .builder()
      .optionallyWith(
        truststoreUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.truststoreUri)
      .optionallyWith(
        truststoreVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.truststoreVersion)
      .optionallyWith(
        truststoreWarnings.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.truststoreWarnings)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly =
    zio.aws.apigatewayv2.model.MutualTlsAuthentication.wrap(buildAwsValue())
}
object MutualTlsAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.MutualTlsAuthentication =
      zio.aws.apigatewayv2.model.MutualTlsAuthentication(
        truststoreUri.map(value => value),
        truststoreVersion.map(value => value),
        truststoreWarnings.map(value => value)
      )
    def truststoreUri: Option[UriWithLengthBetween1And2048]
    def truststoreVersion: Option[StringWithLengthBetween1And64]
    def truststoreWarnings: Option[List[__string]]
    def getTruststoreUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("truststoreUri", truststoreUri)
    def getTruststoreVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("truststoreVersion", truststoreVersion)
    def getTruststoreWarnings: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("truststoreWarnings", truststoreWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
  ) extends zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly {
    override val truststoreUri: Option[UriWithLengthBetween1And2048] = scala
      .Option(impl.truststoreUri())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .UriWithLengthBetween1And2048(value)
      )
    override val truststoreVersion: Option[StringWithLengthBetween1And64] =
      scala
        .Option(impl.truststoreVersion())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And64(value)
        )
    override val truststoreWarnings: Option[List[__string]] = scala
      .Option(impl.truststoreWarnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.MutualTlsAuthentication
  ): zio.aws.apigatewayv2.model.MutualTlsAuthentication.ReadOnly = new Wrapper(
    impl
  )
}
