package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait SecurityPolicy {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy
}
object SecurityPolicy {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy
  ): zio.aws.apigatewayv2.model.SecurityPolicy = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy.TLS_1_0 =>
      val r = TLS_1_0
      r
    case software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy.TLS_1_2 =>
      val r = TLS_1_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.SecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy =
      software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object TLS_1_0 extends zio.aws.apigatewayv2.model.SecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy =
      software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy.TLS_1_0
  }
  case object TLS_1_2 extends zio.aws.apigatewayv2.model.SecurityPolicy {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy =
      software.amazon.awssdk.services.apigatewayv2.model.SecurityPolicy.TLS_1_2
  }
}
