package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDomainNameRequest(
    domainName: __string,
    domainNameConfigurations: Optional[
      Iterable[zio.aws.apigatewayv2.model.DomainNameConfiguration]
    ] = Optional.Absent,
    mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest = {
    import UpdateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainNameConfigurations)
      .optionallyWith(
        mutualTlsAuthentication.map(value => value.buildAwsValue())
      )(_.mutualTlsAuthentication)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateDomainNameRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateDomainNameRequest.wrap(buildAwsValue())
}
object UpdateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateDomainNameRequest =
      zio.aws.apigatewayv2.model.UpdateDomainNameRequest(
        domainName,
        domainNameConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mutualTlsAuthentication.map(value => value.asEditable)
      )
    def domainName: __string
    def domainNameConfigurations: Optional[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ]
    def mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ]
    def getDomainName: ZIO[Any, Nothing, __string] = ZIO.succeed(domainName)
    def getDomainNameConfigurations: ZIO[Any, AwsError, List[
      zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainNameConfigurations",
      domainNameConfigurations
    )
    def getMutualTlsAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mutualTlsAuthentication",
      mutualTlsAuthentication
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
  ) extends zio.aws.apigatewayv2.model.UpdateDomainNameRequest.ReadOnly {
    override val domainName: __string = impl.domainName(): __string
    override val domainNameConfigurations: Optional[
      List[zio.aws.apigatewayv2.model.DomainNameConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainNameConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigatewayv2.model.DomainNameConfiguration.wrap(item)
        }.toList
      )
    override val mutualTlsAuthentication: Optional[
      zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.mutualTlsAuthentication())
      .map(value =>
        zio.aws.apigatewayv2.model.MutualTlsAuthenticationInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateDomainNameRequest
  ): zio.aws.apigatewayv2.model.UpdateDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
