package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReimportApiRequest(
    apiId: __string,
    basepath: Optional[__string] = Optional.Absent,
    body: __string,
    failOnWarnings: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest = {
    import ReimportApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(basepath.map(value => value: java.lang.String))(
        _.basepath
      )
      .body(body: java.lang.String)
      .optionallyWith(failOnWarnings.map(value => value: java.lang.Boolean))(
        _.failOnWarnings
      )
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.ReimportApiRequest.ReadOnly =
    zio.aws.apigatewayv2.model.ReimportApiRequest.wrap(buildAwsValue())
}
object ReimportApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.ReimportApiRequest =
      zio.aws.apigatewayv2.model.ReimportApiRequest(
        apiId,
        basepath.map(value => value),
        body,
        failOnWarnings.map(value => value)
      )
    def apiId: __string
    def basepath: Optional[__string]
    def body: __string
    def failOnWarnings: Optional[__boolean]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getBasepath: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("basepath", basepath)
    def getBody: ZIO[Any, Nothing, __string] = ZIO.succeed(body)
    def getFailOnWarnings: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("failOnWarnings", failOnWarnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
  ) extends zio.aws.apigatewayv2.model.ReimportApiRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val basepath: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.basepath())
      .map(value => value: __string)
    override val body: __string = impl.body(): __string
    override val failOnWarnings: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.failOnWarnings())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.ReimportApiRequest
  ): zio.aws.apigatewayv2.model.ReimportApiRequest.ReadOnly = new Wrapper(impl)
}
