package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait EndpointType {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.EndpointType
}
object EndpointType {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.EndpointType
  ): zio.aws.apigatewayv2.model.EndpointType = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.EndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.EndpointType.REGIONAL =>
      val r = REGIONAL
      r
    case software.amazon.awssdk.services.apigatewayv2.model.EndpointType.EDGE =>
      val r = EDGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.EndpointType =
      software.amazon.awssdk.services.apigatewayv2.model.EndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object REGIONAL extends zio.aws.apigatewayv2.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.EndpointType =
      software.amazon.awssdk.services.apigatewayv2.model.EndpointType.REGIONAL
  }
  case object EDGE extends zio.aws.apigatewayv2.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.EndpointType =
      software.amazon.awssdk.services.apigatewayv2.model.EndpointType.EDGE
  }
}
