package zio.aws.apigatewayv2.model
import scala.jdk.CollectionConverters._
sealed trait IntegrationType {
  def unwrap: software.amazon.awssdk.services.apigatewayv2.model.IntegrationType
}
object IntegrationType {
  def wrap(
      value: software.amazon.awssdk.services.apigatewayv2.model.IntegrationType
  ): zio.aws.apigatewayv2.model.IntegrationType = value match {
    case software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.AWS =>
      val r = AWS
      r
    case software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.MOCK =>
      val r = MOCK
      r
    case software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.HTTP_PROXY =>
      val r = HTTP_PROXY
      r
    case software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.AWS_PROXY =>
      val r = AWS_PROXY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigatewayv2.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.IntegrationType =
      software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS extends zio.aws.apigatewayv2.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.IntegrationType =
      software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.AWS
  }
  case object HTTP extends zio.aws.apigatewayv2.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.IntegrationType =
      software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.HTTP
  }
  case object MOCK extends zio.aws.apigatewayv2.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.IntegrationType =
      software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.MOCK
  }
  case object HTTP_PROXY extends zio.aws.apigatewayv2.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.IntegrationType =
      software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.HTTP_PROXY
  }
  case object AWS_PROXY extends zio.aws.apigatewayv2.model.IntegrationType {
    override def unwrap
        : software.amazon.awssdk.services.apigatewayv2.model.IntegrationType =
      software.amazon.awssdk.services.apigatewayv2.model.IntegrationType.AWS_PROXY
  }
}
