package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  StringWithLengthBetween1And128,
  StringWithLengthBetween0And1024,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeploymentRequest(
    apiId: __string,
    description: Optional[StringWithLengthBetween0And1024] = Optional.Absent,
    stageName: Optional[StringWithLengthBetween1And128] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest = {
    import CreateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        stageName.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.stageName)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateDeploymentRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateDeploymentRequest.wrap(buildAwsValue())
}
object CreateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateDeploymentRequest =
      zio.aws.apigatewayv2.model.CreateDeploymentRequest(
        apiId,
        description.map(value => value),
        stageName.map(value => value)
      )
    def apiId: __string
    def description: Optional[StringWithLengthBetween0And1024]
    def stageName: Optional[StringWithLengthBetween1And128]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getStageName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("stageName", stageName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest
  ) extends zio.aws.apigatewayv2.model.CreateDeploymentRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val description: Optional[StringWithLengthBetween0And1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween0And1024(value)
        )
    override val stageName: Optional[StringWithLengthBetween1And128] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageName())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And128(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateDeploymentRequest
  ): zio.aws.apigatewayv2.model.CreateDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
