package zio.aws.apigatewayv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  IntegerWithLengthBetween0And3600,
  __string,
  __boolean,
  Arn,
  UriWithLengthBetween1And2048,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  StringWithLengthBetween1And128
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAuthorizerRequest(
    apiId: __string,
    authorizerCredentialsArn: Option[Arn] = None,
    authorizerPayloadFormatVersion: Option[StringWithLengthBetween1And64] =
      None,
    authorizerResultTtlInSeconds: Option[IntegerWithLengthBetween0And3600] =
      None,
    authorizerType: zio.aws.apigatewayv2.model.AuthorizerType,
    authorizerUri: Option[UriWithLengthBetween1And2048] = None,
    enableSimpleResponses: Option[__boolean] = None,
    identitySource: Iterable[__string],
    identityValidationExpression: Option[StringWithLengthBetween0And1024] =
      None,
    jwtConfiguration: Option[zio.aws.apigatewayv2.model.JWTConfiguration] =
      None,
    name: StringWithLengthBetween1And128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest = {
    import CreateAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(
        authorizerCredentialsArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.authorizerCredentialsArn)
      .optionallyWith(
        authorizerPayloadFormatVersion.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.authorizerPayloadFormatVersion)
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value =>
          IntegerWithLengthBetween0And3600.unwrap(value): Integer
        )
      )(_.authorizerResultTtlInSeconds)
      .authorizerType(authorizerType.unwrap)
      .optionallyWith(
        authorizerUri.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.authorizerUri)
      .optionallyWith(
        enableSimpleResponses.map(value => value: java.lang.Boolean)
      )(_.enableSimpleResponses)
      .identitySource(identitySource.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        identityValidationExpression.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.identityValidationExpression)
      .optionallyWith(jwtConfiguration.map(value => value.buildAwsValue()))(
        _.jwtConfiguration
      )
      .name(StringWithLengthBetween1And128.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.CreateAuthorizerRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateAuthorizerRequest.wrap(buildAwsValue())
}
object CreateAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.CreateAuthorizerRequest =
      zio.aws.apigatewayv2.model.CreateAuthorizerRequest(
        apiId,
        authorizerCredentialsArn.map(value => value),
        authorizerPayloadFormatVersion.map(value => value),
        authorizerResultTtlInSeconds.map(value => value),
        authorizerType,
        authorizerUri.map(value => value),
        enableSimpleResponses.map(value => value),
        identitySource,
        identityValidationExpression.map(value => value),
        jwtConfiguration.map(value => value.asEditable),
        name
      )
    def apiId: __string
    def authorizerCredentialsArn: Option[Arn]
    def authorizerPayloadFormatVersion: Option[StringWithLengthBetween1And64]
    def authorizerResultTtlInSeconds: Option[IntegerWithLengthBetween0And3600]
    def authorizerType: zio.aws.apigatewayv2.model.AuthorizerType
    def authorizerUri: Option[UriWithLengthBetween1And2048]
    def enableSimpleResponses: Option[__boolean]
    def identitySource: List[__string]
    def identityValidationExpression: Option[StringWithLengthBetween0And1024]
    def jwtConfiguration
        : Option[zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly]
    def name: StringWithLengthBetween1And128
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getAuthorizerCredentialsArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("authorizerCredentialsArn", authorizerCredentialsArn)
    def getAuthorizerPayloadFormatVersion
        : ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField(
        "authorizerPayloadFormatVersion",
        authorizerPayloadFormatVersion
      )
    def getAuthorizerResultTtlInSeconds
        : ZIO[Any, AwsError, IntegerWithLengthBetween0And3600] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
    def getAuthorizerType
        : ZIO[Any, Nothing, zio.aws.apigatewayv2.model.AuthorizerType] =
      ZIO.succeed(authorizerType)
    def getAuthorizerUri: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("authorizerUri", authorizerUri)
    def getEnableSimpleResponses: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enableSimpleResponses", enableSimpleResponses)
    def getIdentitySource: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(identitySource)
    def getIdentityValidationExpression
        : ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
    def getJwtConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("jwtConfiguration", jwtConfiguration)
    def getName: ZIO[Any, Nothing, StringWithLengthBetween1And128] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest
  ) extends zio.aws.apigatewayv2.model.CreateAuthorizerRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val authorizerCredentialsArn: Option[Arn] = scala
      .Option(impl.authorizerCredentialsArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val authorizerPayloadFormatVersion
        : Option[StringWithLengthBetween1And64] = scala
      .Option(impl.authorizerPayloadFormatVersion())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And64(value)
      )
    override val authorizerResultTtlInSeconds
        : Option[IntegerWithLengthBetween0And3600] = scala
      .Option(impl.authorizerResultTtlInSeconds())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .IntegerWithLengthBetween0And3600(value)
      )
    override val authorizerType: zio.aws.apigatewayv2.model.AuthorizerType =
      zio.aws.apigatewayv2.model.AuthorizerType.wrap(impl.authorizerType())
    override val authorizerUri: Option[UriWithLengthBetween1And2048] = scala
      .Option(impl.authorizerUri())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .UriWithLengthBetween1And2048(value)
      )
    override val enableSimpleResponses: Option[__boolean] =
      scala.Option(impl.enableSimpleResponses()).map(value => value: __boolean)
    override val identitySource: List[__string] = impl
      .identitySource()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val identityValidationExpression
        : Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.identityValidationExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val jwtConfiguration
        : Option[zio.aws.apigatewayv2.model.JWTConfiguration.ReadOnly] = scala
      .Option(impl.jwtConfiguration())
      .map(value => zio.aws.apigatewayv2.model.JWTConfiguration.wrap(value))
    override val name: StringWithLengthBetween1And128 =
      zio.aws.apigatewayv2.model.primitives
        .StringWithLengthBetween1And128(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateAuthorizerRequest
  ): zio.aws.apigatewayv2.model.CreateAuthorizerRequest.ReadOnly = new Wrapper(
    impl
  )
}
