package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.StringWithLengthBetween1And512
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TlsConfigInput(
    serverNameToVerify: Option[StringWithLengthBetween1And512] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.TlsConfigInput = {
    import TlsConfigInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.TlsConfigInput
      .builder()
      .optionallyWith(
        serverNameToVerify.map(value =>
          StringWithLengthBetween1And512.unwrap(value): java.lang.String
        )
      )(_.serverNameToVerify)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.TlsConfigInput.ReadOnly =
    zio.aws.apigatewayv2.model.TlsConfigInput.wrap(buildAwsValue())
}
object TlsConfigInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.TlsConfigInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.TlsConfigInput =
      zio.aws.apigatewayv2.model
        .TlsConfigInput(serverNameToVerify.map(value => value))
    def serverNameToVerify: Option[StringWithLengthBetween1And512]
    def getServerNameToVerify
        : ZIO[Any, AwsError, StringWithLengthBetween1And512] =
      AwsError.unwrapOptionField("serverNameToVerify", serverNameToVerify)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.TlsConfigInput
  ) extends zio.aws.apigatewayv2.model.TlsConfigInput.ReadOnly {
    override val serverNameToVerify: Option[StringWithLengthBetween1And512] =
      scala
        .Option(impl.serverNameToVerify())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives
            .StringWithLengthBetween1And512(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.TlsConfigInput
  ): zio.aws.apigatewayv2.model.TlsConfigInput.ReadOnly = new Wrapper(impl)
}
