package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  SelectionKey,
  SelectionExpression,
  StringWithLengthBetween1And512,
  StringWithLengthBetween0And32K
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIntegrationResponseRequest(
    apiId: __string,
    contentHandlingStrategy: Option[
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = None,
    integrationId: __string,
    integrationResponseKey: SelectionKey,
    responseParameters: Option[Map[__string, StringWithLengthBetween1And512]] =
      None,
    responseTemplates: Option[Map[__string, StringWithLengthBetween0And32K]] =
      None,
    templateSelectionExpression: Option[SelectionExpression] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest = {
    import CreateIntegrationResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .optionallyWith(contentHandlingStrategy.map(value => value.unwrap))(
        _.contentHandlingStrategy
      )
      .integrationId(integrationId: java.lang.String)
      .integrationResponseKey(
        SelectionKey.unwrap(integrationResponseKey): java.lang.String
      )
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween1And512.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (StringWithLengthBetween0And32K
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(
        templateSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.templateSelectionExpression)
      .build()
  }
  def asReadOnly
      : zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest.ReadOnly =
    zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest
      .wrap(buildAwsValue())
}
object CreateIntegrationResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest =
      zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest(
        apiId,
        contentHandlingStrategy.map(value => value),
        integrationId,
        integrationResponseKey,
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        templateSelectionExpression.map(value => value)
      )
    def apiId: __string
    def contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy]
    def integrationId: __string
    def integrationResponseKey: SelectionKey
    def responseParameters
        : Option[Map[__string, StringWithLengthBetween1And512]]
    def responseTemplates: Option[Map[__string, StringWithLengthBetween0And32K]]
    def templateSelectionExpression: Option[SelectionExpression]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getContentHandlingStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.apigatewayv2.model.ContentHandlingStrategy
    ] = AwsError.unwrapOptionField(
      "contentHandlingStrategy",
      contentHandlingStrategy
    )
    def getIntegrationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(integrationId)
    def getIntegrationResponseKey: ZIO[Any, Nothing, SelectionKey] =
      ZIO.succeed(integrationResponseKey)
    def getResponseParameters
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween1And512]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates
        : ZIO[Any, AwsError, Map[__string, StringWithLengthBetween0And32K]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getTemplateSelectionExpression
        : ZIO[Any, AwsError, SelectionExpression] = AwsError.unwrapOptionField(
      "templateSelectionExpression",
      templateSelectionExpression
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest
  ) extends zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest.ReadOnly {
    override val apiId: __string = impl.apiId(): __string
    override val contentHandlingStrategy
        : Option[zio.aws.apigatewayv2.model.ContentHandlingStrategy] = scala
      .Option(impl.contentHandlingStrategy())
      .map(value =>
        zio.aws.apigatewayv2.model.ContentHandlingStrategy.wrap(value)
      )
    override val integrationId: __string = impl.integrationId(): __string
    override val integrationResponseKey: SelectionKey =
      zio.aws.apigatewayv2.model.primitives
        .SelectionKey(impl.integrationResponseKey())
    override val responseParameters
        : Option[Map[__string, StringWithLengthBetween1And512]] = scala
      .Option(impl.responseParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween1And512(value)
          })
          .toMap
      )
    override val responseTemplates
        : Option[Map[__string, StringWithLengthBetween0And32K]] = scala
      .Option(impl.responseTemplates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> zio.aws.apigatewayv2.model.primitives
              .StringWithLengthBetween0And32K(value)
          })
          .toMap
      )
    override val templateSelectionExpression: Option[SelectionExpression] =
      scala
        .Option(impl.templateSelectionExpression())
        .map(value =>
          zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.CreateIntegrationResponseRequest
  ): zio.aws.apigatewayv2.model.CreateIntegrationResponseRequest.ReadOnly =
    new Wrapper(impl)
}
