package zio.aws.apigatewayv2.model
import zio.ZIO
import zio.aws.apigatewayv2.model.primitives.{
  __string,
  __boolean,
  Arn,
  UriWithLengthBetween1And2048,
  SelectionKey,
  StringWithLengthBetween1And64,
  StringWithLengthBetween0And1024,
  SelectionExpression,
  StringWithLengthBetween1And128
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateApiRequest(
    apiId: __string,
    apiKeySelectionExpression: Option[SelectionExpression] = None,
    corsConfiguration: Option[zio.aws.apigatewayv2.model.Cors] = None,
    credentialsArn: Option[Arn] = None,
    description: Option[StringWithLengthBetween0And1024] = None,
    disableSchemaValidation: Option[__boolean] = None,
    disableExecuteApiEndpoint: Option[__boolean] = None,
    name: Option[StringWithLengthBetween1And128] = None,
    routeKey: Option[SelectionKey] = None,
    routeSelectionExpression: Option[SelectionExpression] = None,
    target: Option[UriWithLengthBetween1And2048] = None,
    version: Option[StringWithLengthBetween1And64] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest = {
    import UpdateApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
      .builder()
      .apiId(__string.unwrap(apiId): java.lang.String)
      .optionallyWith(
        apiKeySelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.apiKeySelectionExpression)
      .optionallyWith(corsConfiguration.map(value => value.buildAwsValue()))(
        _.corsConfiguration
      )
      .optionallyWith(
        credentialsArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.credentialsArn)
      .optionallyWith(
        description.map(value =>
          StringWithLengthBetween0And1024.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        disableSchemaValidation.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.disableSchemaValidation)
      .optionallyWith(
        disableExecuteApiEndpoint.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.disableExecuteApiEndpoint)
      .optionallyWith(
        name.map(value =>
          StringWithLengthBetween1And128.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        routeKey.map(value => SelectionKey.unwrap(value): java.lang.String)
      )(_.routeKey)
      .optionallyWith(
        routeSelectionExpression.map(value =>
          SelectionExpression.unwrap(value): java.lang.String
        )
      )(_.routeSelectionExpression)
      .optionallyWith(
        target.map(value =>
          UriWithLengthBetween1And2048.unwrap(value): java.lang.String
        )
      )(_.target)
      .optionallyWith(
        version.map(value =>
          StringWithLengthBetween1And64.unwrap(value): java.lang.String
        )
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.apigatewayv2.model.UpdateApiRequest.ReadOnly =
    zio.aws.apigatewayv2.model.UpdateApiRequest.wrap(buildAwsValue())
}
object UpdateApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigatewayv2.model.UpdateApiRequest =
      zio.aws.apigatewayv2.model.UpdateApiRequest(
        apiId,
        apiKeySelectionExpression.map(value => value),
        corsConfiguration.map(value => value.asEditable),
        credentialsArn.map(value => value),
        description.map(value => value),
        disableSchemaValidation.map(value => value),
        disableExecuteApiEndpoint.map(value => value),
        name.map(value => value),
        routeKey.map(value => value),
        routeSelectionExpression.map(value => value),
        target.map(value => value),
        version.map(value => value)
      )
    def apiId: __string
    def apiKeySelectionExpression: Option[SelectionExpression]
    def corsConfiguration: Option[zio.aws.apigatewayv2.model.Cors.ReadOnly]
    def credentialsArn: Option[Arn]
    def description: Option[StringWithLengthBetween0And1024]
    def disableSchemaValidation: Option[__boolean]
    def disableExecuteApiEndpoint: Option[__boolean]
    def name: Option[StringWithLengthBetween1And128]
    def routeKey: Option[SelectionKey]
    def routeSelectionExpression: Option[SelectionExpression]
    def target: Option[UriWithLengthBetween1And2048]
    def version: Option[StringWithLengthBetween1And64]
    def getApiId: ZIO[Any, Nothing, __string] = ZIO.succeed(apiId)
    def getApiKeySelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "apiKeySelectionExpression",
        apiKeySelectionExpression
      )
    def getCorsConfiguration
        : ZIO[Any, AwsError, zio.aws.apigatewayv2.model.Cors.ReadOnly] =
      AwsError.unwrapOptionField("corsConfiguration", corsConfiguration)
    def getCredentialsArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("credentialsArn", credentialsArn)
    def getDescription: ZIO[Any, AwsError, StringWithLengthBetween0And1024] =
      AwsError.unwrapOptionField("description", description)
    def getDisableSchemaValidation: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableSchemaValidation", disableSchemaValidation)
    def getDisableExecuteApiEndpoint: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableExecuteApiEndpoint", disableExecuteApiEndpoint)
    def getName: ZIO[Any, AwsError, StringWithLengthBetween1And128] =
      AwsError.unwrapOptionField("name", name)
    def getRouteKey: ZIO[Any, AwsError, SelectionKey] =
      AwsError.unwrapOptionField("routeKey", routeKey)
    def getRouteSelectionExpression: ZIO[Any, AwsError, SelectionExpression] =
      AwsError.unwrapOptionField(
        "routeSelectionExpression",
        routeSelectionExpression
      )
    def getTarget: ZIO[Any, AwsError, UriWithLengthBetween1And2048] =
      AwsError.unwrapOptionField("target", target)
    def getVersion: ZIO[Any, AwsError, StringWithLengthBetween1And64] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
  ) extends zio.aws.apigatewayv2.model.UpdateApiRequest.ReadOnly {
    override val apiId: __string =
      zio.aws.apigatewayv2.model.primitives.__string(impl.apiId())
    override val apiKeySelectionExpression: Option[SelectionExpression] = scala
      .Option(impl.apiKeySelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val corsConfiguration
        : Option[zio.aws.apigatewayv2.model.Cors.ReadOnly] = scala
      .Option(impl.corsConfiguration())
      .map(value => zio.aws.apigatewayv2.model.Cors.wrap(value))
    override val credentialsArn: Option[Arn] = scala
      .Option(impl.credentialsArn())
      .map(value => zio.aws.apigatewayv2.model.primitives.Arn(value))
    override val description: Option[StringWithLengthBetween0And1024] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween0And1024(value)
      )
    override val disableSchemaValidation: Option[__boolean] = scala
      .Option(impl.disableSchemaValidation())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val disableExecuteApiEndpoint: Option[__boolean] = scala
      .Option(impl.disableExecuteApiEndpoint())
      .map(value => zio.aws.apigatewayv2.model.primitives.__boolean(value))
    override val name: Option[StringWithLengthBetween1And128] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And128(value)
      )
    override val routeKey: Option[SelectionKey] = scala
      .Option(impl.routeKey())
      .map(value => zio.aws.apigatewayv2.model.primitives.SelectionKey(value))
    override val routeSelectionExpression: Option[SelectionExpression] = scala
      .Option(impl.routeSelectionExpression())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives.SelectionExpression(value)
      )
    override val target: Option[UriWithLengthBetween1And2048] = scala
      .Option(impl.target())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .UriWithLengthBetween1And2048(value)
      )
    override val version: Option[StringWithLengthBetween1And64] = scala
      .Option(impl.version())
      .map(value =>
        zio.aws.apigatewayv2.model.primitives
          .StringWithLengthBetween1And64(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigatewayv2.model.UpdateApiRequest
  ): zio.aws.apigatewayv2.model.UpdateApiRequest.ReadOnly = new Wrapper(impl)
}
